/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DumpBucketsMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    boolean validateOnly;
    boolean bucketsOnly;

    public DumpBucketsMessage() {
    }

    private DumpBucketsMessage(Set recipients, int regionId, ReplyProcessor21 processor, boolean validate, boolean buckets) {
        super(recipients, regionId, processor);
        this.validateOnly = validate;
        this.bucketsOnly = buckets;
    }

    public static PartitionMessage.PartitionResponse send(Set recipients, PartitionedRegion r, boolean validateOnly, boolean onlyBuckets) {
        PartitionMessage.PartitionResponse p = new PartitionMessage.PartitionResponse(r.getSystem(), recipients);
        DumpBucketsMessage m = new DumpBucketsMessage(recipients, r.getPRId(), p, validateOnly, onlyBuckets);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        PartitionedRegionDataStore ds;
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "DumpBucketsMessage operateOnRegion: {}", (Object)pr.getFullPath());
        }
        if ((ds = pr.getDataStore()) != null) {
            if (this.bucketsOnly) {
                ds.dumpBuckets();
            } else {
                ds.dumpEntries(this.validateOnly);
            }
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} dumped buckets", (Object)this.getClass().getName());
            }
        }
        return true;
    }

    public int getDSFID() {
        return 45;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.validateOnly = in.readBoolean();
        this.bucketsOnly = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeBoolean(this.validateOnly);
        out.writeBoolean(this.bucketsOnly);
    }
}

