/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RemoveClientFromDenylistMessage
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private ClientProxyMembershipID proxyID;

    @Override
    protected void process(ClusterDistributionManager dm) {
        List<CacheServer> l;
        InternalCache c = dm.getCache();
        if (c != null && (l = c.getCacheServers()) != null) {
            for (CacheServer o : l) {
                InternalDistributedSystem ds;
                CacheServerImpl bs = (CacheServerImpl)o;
                CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
                Set<ClientProxyMembershipID> s = ccn.getDenylistedClient();
                if (s == null || !s.remove(this.proxyID) || (ds = dm.getSystem()) == null || !logger.isDebugEnabled()) continue;
                logger.debug("Remove the client from deny list as its queue is already destroyed: {}", (Object)this.proxyID);
            }
        }
    }

    public RemoveClientFromDenylistMessage() {
        this.setRecipient(ALL_RECIPIENTS);
    }

    public void setProxyID(ClientProxyMembershipID proxyID) {
        this.proxyID = proxyID;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.proxyID, out);
    }

    public int getDSFID() {
        return -44;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.proxyID = ClientProxyMembershipID.readCanonicalized(in);
    }
}

