/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.operations.GetOperationContext;
import org.apache.geode.cache.operations.internal.GetOperationContextImpl;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.VersionTagHolder;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class Get70
extends BaseCommand {
    @Immutable
    private static final Get70 singleton = new Get70();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long startparam) throws IOException {
        Object originalData;
        Entry entry;
        Object key;
        long start = startparam;
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadGetRequestTime(start - oldStart);
        int parts = clientMessage.getNumberOfParts();
        Part regionNamePart = clientMessage.getPart(0);
        Part keyPart = clientMessage.getPart(1);
        Object callbackArg = null;
        if (parts > 2) {
            Part valuePart = clientMessage.getPart(2);
            try {
                callbackArg = valuePart.getObject();
            }
            catch (Exception e) {
                Get70.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        String regionName = regionNamePart.getCachedString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Get70.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received 7.0 get request ({} bytes) from {} for region {} key {} txId {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)clientMessage.getTransactionId());
        }
        if (key == null || regionName == null) {
            String errMessage = key == null && regionName == null ? "The input region name and key for the get request are null." : (key == null ? "The input key for the get request is null." : "The input region name for the get request is null.");
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)errMessage);
            Get70.writeErrorResponse(clientMessage, 3, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Region region = serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = " was not found during get request";
            Get70.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        GetOperationContext getContext = null;
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName, key);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                getContext = authzRequest.getAuthorize(regionName, key, callbackArg);
                callbackArg = getContext.getCallbackArg();
            }
        }
        catch (NotAuthorizedException ex) {
            Get70.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            entry = this.getEntry(region, key, callbackArg, serverConnection);
        }
        catch (Exception e) {
            Get70.writeException(clientMessage, e, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Object data = originalData = entry.value;
        try {
            boolean keyNotPresent;
            VersionTag<?> versionTag;
            boolean isObject;
            block30: {
                isObject = entry.isObject;
                versionTag = entry.versionTag;
                keyNotPresent = entry.keyNotPresent;
                try {
                    AuthorizeRequestPP postAuthzRequest = serverConnection.getPostAuthzRequest();
                    if (postAuthzRequest == null) break block30;
                    try {
                        getContext = postAuthzRequest.getAuthorize(regionName, key, data, isObject, getContext);
                        GetOperationContextImpl gci = (GetOperationContextImpl)getContext;
                        Object newData = gci.getRawValue();
                        if (newData != data) {
                            isObject = getContext.isObject();
                            data = newData;
                        }
                    }
                    finally {
                        if (getContext != null) {
                            ((GetOperationContextImpl)getContext).release();
                        }
                    }
                }
                catch (NotAuthorizedException ex) {
                    Get70.writeException(clientMessage, ex, false, serverConnection);
                    serverConnection.setAsTrue(1);
                    OffHeapHelper.release(originalData);
                    return;
                }
            }
            data = securityService.postProcess(regionName, key, data, entry.isObject);
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessGetTime(start - oldStart2);
            if (region instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)region;
                if (pr.getNetworkHopType() != 0) {
                    this.writeResponseWithRefreshMetadata(data, callbackArg, clientMessage, isObject, serverConnection, pr, pr.getNetworkHopType(), versionTag, keyNotPresent);
                    pr.clearNetworkHopData();
                } else {
                    this.writeResponse(data, callbackArg, clientMessage, isObject, versionTag, keyNotPresent, serverConnection);
                }
            } else {
                this.writeResponse(data, callbackArg, clientMessage, isObject, versionTag, keyNotPresent, serverConnection);
            }
        }
        finally {
            OffHeapHelper.release(originalData);
        }
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Wrote get response back to {} for region {} {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)regionName, (Object)entry);
        }
        stats.incWriteGetResponseTime(DistributionStats.getStatTime() - start);
        CachePerfStats regionPerfStats = ((InternalRegion)region).getRegionPerfStats();
        if (regionPerfStats != null) {
            regionPerfStats.endGetForClient(startparam, entry.keyNotPresent);
        }
    }

    protected Entry getEntry(Region<?, ?> region, Object key, Object callbackArg, ServerConnection servConn) {
        return this.getEntryRetained(region, key, callbackArg, servConn);
    }

    public Entry getValueAndIsObject(Region<?, ?> region, Object key, Object callbackArg, ServerConnection servConn) {
        String regionName = region.getFullPath();
        if (servConn != null) {
            servConn.setModificationInfo(true, regionName, key);
        }
        ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
        VersionTagHolder versionHolder = new VersionTagHolder();
        Object data = ((LocalRegion)region).get(key, callbackArg, true, true, true, id, versionHolder, true);
        VersionTag versionTag = versionHolder.getVersionTag();
        boolean wasInvalid = false;
        boolean isObject = true;
        if (data instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)data;
            if (!cd.isSerialized()) {
                isObject = false;
                data = cd.getDeserializedForReading();
            } else {
                data = cd.getValue();
            }
        } else if (data == Token.REMOVED_PHASE1 || data == Token.REMOVED_PHASE2 || data == Token.DESTROYED) {
            data = null;
        } else if (data == Token.INVALID || data == Token.LOCAL_INVALID) {
            data = null;
            wasInvalid = true;
        } else if (data instanceof byte[]) {
            isObject = false;
        }
        boolean keyNotPresent = !wasInvalid && (data == null || data == Token.TOMBSTONE);
        return new Entry(data, isObject, keyNotPresent, versionTag);
    }

    public Entry getEntryRetained(Region<?, ?> region, Object key, Object callbackArg, ServerConnection servConn) {
        String regionName = region.getFullPath();
        if (servConn != null) {
            servConn.setModificationInfo(true, regionName, key);
        }
        ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
        VersionTagHolder versionHolder = new VersionTagHolder();
        Object data = ((LocalRegion)region).getRetained(key, callbackArg, true, true, id, versionHolder, true);
        VersionTag versionTag = versionHolder.getVersionTag();
        boolean wasInvalid = false;
        boolean isObject = true;
        if (data == Token.REMOVED_PHASE1 || data == Token.REMOVED_PHASE2 || data == Token.DESTROYED) {
            data = null;
        } else if (data == Token.INVALID || data == Token.LOCAL_INVALID) {
            data = null;
            wasInvalid = true;
        } else if (data instanceof byte[]) {
            isObject = false;
        } else if (data instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)data;
            isObject = cd.isSerialized();
            if (cd.usesHeapForStorage()) {
                data = cd.getValue();
            }
        }
        boolean keyNotPresent = !wasInvalid && (data == null || data == Token.TOMBSTONE);
        return new Entry(data, isObject, keyNotPresent, versionTag);
    }

    @Override
    protected void writeReply(@NotNull Message origMsg, @NotNull ServerConnection serverConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, VersionTag<?> versionTag, boolean keyNotPresent, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        int numParts = 2;
        int flags = 0;
        if (callbackArg != null) {
            ++numParts;
            flags |= 1;
        }
        if (versionTag != null) {
            ++numParts;
            flags |= 2;
        }
        if (keyNotPresent) {
            flags |= 4;
        } else if (data == null && isObject) {
            flags |= 8;
        }
        responseMsg.setNumberOfParts(numParts);
        responseMsg.addPartInAnyForm(data, isObject);
        responseMsg.addIntPart(flags);
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        if (versionTag != null) {
            responseMsg.addObjPart(versionTag);
        }
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    private void writeResponseWithRefreshMetadata(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn, PartitionedRegion pr, byte nwHop, VersionTag<?> versionTag, boolean keyNotPresent) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        int numParts = 3;
        int flags = 0;
        if (callbackArg != null) {
            ++numParts;
            flags |= 1;
        }
        if (versionTag != null) {
            ++numParts;
            flags |= 2;
        }
        if (keyNotPresent) {
            flags |= 4;
        } else if (data == null && isObject) {
            flags |= 8;
        }
        responseMsg.setNumberOfParts(numParts);
        responseMsg.addPartInAnyForm(data, isObject);
        responseMsg.addIntPart(flags);
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        if (versionTag != null) {
            responseMsg.addObjPart(versionTag);
        }
        responseMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    public static class Entry {
        public final Object value;
        public final boolean isObject;
        public final boolean keyNotPresent;
        public final VersionTag<?> versionTag;

        public Entry(Object value, boolean isObject, boolean keyNotPresent, VersionTag<?> versionTag) {
            this.value = value;
            this.isObject = isObject;
            this.keyNotPresent = keyNotPresent;
            this.versionTag = versionTag;
        }

        public String toString() {
            return "value=" + this.value + " isObject=" + this.isObject + " notPresent=" + this.keyNotPresent + " version=" + this.versionTag;
        }
    }
}

