/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.management.MBeanException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.management.internal.OpenTypeConverter;

public class OpenMethod {
    @Immutable
    private static final OpenType[] noOpenTypes = new OpenType[0];
    private static final String[] noStrings = new String[0];
    private final Method method;
    private final OpenTypeConverter returnTypeConverter;
    private final OpenTypeConverter[] paramTypeConverters;
    private final boolean paramConversionIsIdentity;

    static OpenMethod from(Method m) {
        try {
            return new OpenMethod(m);
        }
        catch (OpenDataException ode) {
            String msg = "Method " + m.getDeclaringClass().getName() + "." + m.getName() + " has parameter or return type that cannot be translated into an open type";
            throw new IllegalArgumentException(msg, ode);
        }
    }

    Method getMethod() {
        return this.method;
    }

    Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    String getName() {
        return this.method.getName();
    }

    OpenType getOpenReturnType() {
        return this.returnTypeConverter.getOpenType();
    }

    OpenType[] getOpenParameterTypes() {
        OpenType[] types = new OpenType[this.paramTypeConverters.length];
        for (int i = 0; i < this.paramTypeConverters.length; ++i) {
            types[i] = this.paramTypeConverters[i].getOpenType();
        }
        return types;
    }

    void checkCallFromOpen() throws IllegalArgumentException {
        try {
            for (OpenTypeConverter paramConverter : this.paramTypeConverters) {
                paramConverter.checkReconstructible();
            }
        }
        catch (InvalidObjectException e) {
            throw new IllegalArgumentException(e);
        }
    }

    void checkCallToOpen() throws IllegalArgumentException {
        try {
            this.returnTypeConverter.checkReconstructible();
        }
        catch (InvalidObjectException e) {
            throw new IllegalArgumentException(e);
        }
    }

    String[] getOpenSignature() {
        if (this.paramTypeConverters.length == 0) {
            return noStrings;
        }
        String[] sig = new String[this.paramTypeConverters.length];
        for (int i = 0; i < this.paramTypeConverters.length; ++i) {
            sig[i] = this.paramTypeConverters[i].getOpenClass().getName();
        }
        return sig;
    }

    Object toOpenReturnValue(Object ret) throws OpenDataException {
        return this.returnTypeConverter.toOpenValue(ret);
    }

    Object fromOpenReturnValue(Object ret) throws InvalidObjectException {
        return this.returnTypeConverter.fromOpenValue(ret);
    }

    Object[] toOpenParameters(Object[] params) throws OpenDataException {
        if (this.paramConversionIsIdentity || params == null) {
            return params;
        }
        Object[] oparams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            oparams[i] = this.paramTypeConverters[i].toOpenValue(params[i]);
        }
        return oparams;
    }

    Object[] fromOpenParameters(Object[] params) throws InvalidObjectException {
        if (this.paramConversionIsIdentity || params == null) {
            return params;
        }
        Object[] jparams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            jparams[i] = this.paramTypeConverters[i].fromOpenValue(params[i]);
        }
        return jparams;
    }

    Object toOpenParameter(Object param, int paramNo) throws OpenDataException {
        return this.paramTypeConverters[paramNo].toOpenValue(param);
    }

    Object fromOpenParameter(Object param, int paramNo) throws InvalidObjectException {
        return this.paramTypeConverters[paramNo].fromOpenValue(param);
    }

    Object invokeWithOpenReturn(Object obj, Object[] params) throws MBeanException, IllegalAccessException, InvocationTargetException {
        Object[] javaParams;
        try {
            javaParams = this.fromOpenParameters(params);
        }
        catch (InvalidObjectException e) {
            String msg = this.methodName() + ": cannot convert parameters from open values: " + e;
            throw new MBeanException(e, msg);
        }
        Object javaReturn = this.method.invoke(obj, javaParams);
        try {
            return this.returnTypeConverter.toOpenValue(javaReturn);
        }
        catch (OpenDataException e) {
            String msg = this.methodName() + ": cannot convert return value to open value: " + e;
            throw new MBeanException(e, msg);
        }
    }

    private String methodName() {
        return this.method.getDeclaringClass() + "." + this.method.getName();
    }

    private OpenMethod(Method m) throws OpenDataException {
        this.method = m;
        this.returnTypeConverter = OpenTypeConverter.toConverter(m.getGenericReturnType());
        Type[] params = m.getGenericParameterTypes();
        this.paramTypeConverters = new OpenTypeConverter[params.length];
        boolean identity = true;
        for (int i = 0; i < params.length; ++i) {
            this.paramTypeConverters[i] = OpenTypeConverter.toConverter(params[i]);
            identity &= this.paramTypeConverters[i].isIdentity();
        }
        this.paramConversionIsIdentity = identity;
    }
}

