/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.services.result.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.services.result.ServiceResult;

public class Failure<SuccessType>
implements ServiceResult<SuccessType> {
    private final String errorMessage;

    private Failure(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static <T> Failure<T> of(String errorMessage) {
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            throw new IllegalArgumentException("Error message cannot be null or empty");
        }
        return new Failure(errorMessage);
    }

    public static <T> Failure<T> of(Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("Error message cannot be null or empty");
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
            Failure failure = new Failure(stringWriter.toString());
            return failure;
        }
    }

    public static <T> Failure<T> of(String errorMessage, Throwable throwable) {
        if (throwable == null || StringUtils.isBlank((CharSequence)errorMessage)) {
            throw new IllegalArgumentException("Error message cannot be null or empty");
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
            Failure failure = new Failure(errorMessage + "\n" + stringWriter);
            return failure;
        }
    }

    @Override
    public <T> T map(Function<SuccessType, T> successFunction, Function<String, T> errorFunction) {
        return errorFunction.apply(this.errorMessage);
    }

    @Override
    public SuccessType getMessage() {
        throw new RuntimeException("This Result is not of type Success.");
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public ServiceResult<SuccessType> ifFailure(Consumer<? super String> consumer) {
        if (this.isFailure()) {
            consumer.accept(this.errorMessage);
        }
        return this;
    }

    @Override
    public boolean isFailure() {
        return true;
    }
}

