/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.service.internal.api;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.api.ClusterManagementServiceTransport;
import org.apache.geode.management.api.ConnectionConfig;
import org.apache.geode.management.api.RestTemplateClusterManagementServiceTransport;
import org.apache.geode.management.cluster.client.internal.ClientClusterManagementService;

public abstract class BaseManagementServiceBuilder<T extends BaseManagementServiceBuilder<?>> {
    private ClusterManagementServiceTransport transport;
    private String username;
    private String password;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;
    private String authToken;
    private Boolean followRedirects;

    public ClusterManagementService build() {
        return new ClientClusterManagementService(this.configureTransport());
    }

    private ClusterManagementServiceTransport configureTransport() {
        if (this.transport == null) {
            ConnectionConfig connectionConfig = this.createConnectionConfig();
            connectionConfig = this.configureConnectionConfig(connectionConfig);
            return new RestTemplateClusterManagementServiceTransport(connectionConfig);
        }
        return this.transport;
    }

    private T self() {
        return (T)this;
    }

    public T setTransport(ClusterManagementServiceTransport transport) {
        this.transport = transport;
        return this.self();
    }

    public T setAuthToken(String token) {
        this.authToken = token;
        return this.self();
    }

    public T setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this.self();
    }

    public T setUsername(String username) {
        this.username = username;
        return this.self();
    }

    public T setPassword(String password) {
        this.password = password;
        return this.self();
    }

    public T setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this.self();
    }

    public T setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this.self();
    }

    protected abstract ConnectionConfig createConnectionConfig();

    protected ConnectionConfig configureConnectionConfig(ConnectionConfig newConnectionConfig) {
        if (this.authToken != null) {
            newConnectionConfig.setAuthToken(this.authToken);
        }
        if (this.followRedirects != null) {
            newConnectionConfig.setFollowRedirects(this.followRedirects);
        }
        if (this.hostnameVerifier != null) {
            newConnectionConfig.setHostnameVerifier(this.hostnameVerifier);
        }
        if (this.username != null) {
            newConnectionConfig.setUsername(this.username);
        }
        if (this.password != null) {
            newConnectionConfig.setPassword(this.password);
        }
        if (this.sslContext != null) {
            newConnectionConfig.setSslContext(this.sslContext);
        }
        return newConnectionConfig;
    }
}

