/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.domain.MemberConfigurationInfo;
import org.apache.geode.management.internal.cli.functions.GetMemberConfigInformationFunction;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeConfigCommand
extends GfshCommand {
    public static final String API_PROPERTIES_SECTION = "api-properties";
    public static final String RUNTIME_PROPERTIES_SECTION = "runtime-properties";
    public static final String FILE_PROPERTIES_SECTION = "file-properties";
    public static final String DEFAULT_PROPERTIES_SECTION = "default-properties";
    public static final String CACHE_ATTRIBUTES_SECTION = "cache-attributes";
    public static final String CACHESERVER_ATTRIBUTES_SECTION = "cacheserver-attributes";
    public static final String JVM_ARGS_SECTION = "jvm-args";
    private final GetMemberConfigInformationFunction getMemberConfigFunction = new GetMemberConfigInformationFunction();

    @CliCommand(value={"describe config"}, help="Display configuration details of a member or members.")
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel describeConfig(@CliOption(key={"member"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Name/Id of the member whose configuration will be described.", mandatory=true) String memberNameOrId, @CliOption(key={"hide-defaults"}, help="Whether to hide configuration information for properties with the default value.", unspecifiedDefaultValue="true", specifiedDefaultValue="true") boolean hideDefaults) {
        CliFunctionResult functionResult;
        Object obj;
        ResultModel result = new ResultModel();
        DistributedMember targetMember = null;
        if (memberNameOrId != null && !memberNameOrId.isEmpty()) {
            targetMember = this.getMember(memberNameOrId);
        }
        if ((obj = (functionResult = this.executeFunctionAndGetFunctionResult((Function<?>)this.getMemberConfigFunction, hideDefaults, targetMember)).getResultObject()) != null && obj instanceof MemberConfigurationInfo) {
            MemberConfigurationInfo memberConfigInfo = (MemberConfigurationInfo)obj;
            result.setHeader(CliStrings.format((String)"Configuration of member : \"{0}\"", (Object)memberNameOrId));
            List<String> jvmArgsList = memberConfigInfo.getJvmInputArguments();
            TabularResultModel jvmInputArgs = result.addTable(JVM_ARGS_SECTION);
            for (String jvmArg : jvmArgsList) {
                jvmInputArgs.accumulate("JVM command line arguments", ArgumentRedactor.redact((String)jvmArg));
            }
            this.addSection(API_PROPERTIES_SECTION, result, memberConfigInfo.getGfePropsSetUsingApi(), "GemFire properties defined using the API");
            this.addSection(RUNTIME_PROPERTIES_SECTION, result, memberConfigInfo.getGfePropsRuntime(), "GemFire properties defined at the runtime");
            this.addSection(FILE_PROPERTIES_SECTION, result, memberConfigInfo.getGfePropsSetFromFile(), "GemFire properties defined with the property file");
            this.addSection(DEFAULT_PROPERTIES_SECTION, result, memberConfigInfo.getGfePropsSetWithDefaults(), "GemFire properties using default values");
            this.addSection(CACHE_ATTRIBUTES_SECTION, result, memberConfigInfo.getCacheAttributes(), "Cache attributes");
            List<Map<String, String>> cacheServerAttributesList = memberConfigInfo.getCacheServerAttributes();
            if (cacheServerAttributesList != null && !cacheServerAttributesList.isEmpty()) {
                for (Map<String, String> cacheServerAttributes : cacheServerAttributesList) {
                    this.addSection(CACHESERVER_ATTRIBUTES_SECTION, result, cacheServerAttributes, "Cache-server attributes");
                }
            }
        }
        return result;
    }

    private void addSection(String namedSection, ResultModel model, Map<String, String> attrMap, String headerText) {
        if (attrMap != null && !attrMap.isEmpty()) {
            DataResultModel dataSection = model.addData(namedSection);
            dataSection.setHeader(headerText);
            TreeSet<String> attributes = new TreeSet<String>(attrMap.keySet());
            for (String attribute : attributes) {
                String attributeValue = attrMap.get(attribute);
                dataSection.addData(attribute, ArgumentRedactor.redactArgumentIfNecessary((String)attribute, (String)attributeValue));
            }
        }
    }
}

