/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ResumeAsyncEventQueueDispatcherFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ResumeAsyncEventQueueDispatcherCommand
extends GfshCommand {
    @CliCommand(value={"resume async-event-queue-dispatcher"}, help="Resume the processing of the events in the Async Event Queue on a member or members.")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel resumeAsyncEventQueueDispatcher(@CliOption(key={"id"}, mandatory=true, help="ID of the Async Event Queue.") String queueId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to resume processing of the events.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to resume processing of the events.") String[] onMember) {
        if (queueId != null) {
            queueId = queueId.trim();
        }
        Set<DistributedMember> targetMembers = this.findMembers(onGroup, onMember);
        List<CliFunctionResult> results = this.executeAndGetFunctionResult((Function<?>)new ResumeAsyncEventQueueDispatcherFunction(), queueId, targetMembers);
        return this.constructResultModel(results);
    }

    ResultModel constructResultModel(List<CliFunctionResult> results) {
        return ResultModel.createMemberStatusResult(results);
    }
}

