/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.configuration.GatewayReceiverConfig;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.configuration.realizers.GatewayReceiverRealizer;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class GatewayReceiverCreateFunction
implements InternalFunction<Object[]> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    @Immutable
    public static final GatewayReceiverCreateFunction INSTANCE = new GatewayReceiverCreateFunction();
    private static final String ID = "org.apache.geode.management.internal.cli.functions.GatewayReceiverCreateFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<Object[]> context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        Object[] gatewayReceiverCreateArgs = (Object[])context.getArguments();
        GatewayReceiverConfig gatewayReceiverConfig = (GatewayReceiverConfig)gatewayReceiverCreateArgs[0];
        Boolean ifNotExist = (Boolean)gatewayReceiverCreateArgs[1];
        if (this.gatewayReceiverExists(cache)) {
            CliFunctionResult result;
            if (ifNotExist.booleanValue()) {
                result = new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, "Skipping: A Gateway Receiver already exists on this member.");
            } else {
                IllegalStateException illegalState = new IllegalStateException("A Gateway Receiver already exists on this member.");
                result = new CliFunctionResult(memberNameOrId, (Object)illegalState, illegalState.getMessage());
            }
            resultSender.lastResult((Object)result);
            return;
        }
        try {
            GatewayReceiver createdGatewayReceiver = this.createGatewayReceiver(cache, gatewayReceiverConfig);
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format((String)"GatewayReceiver created on member \"{0}\" and will listen on the port \"{1}\"", (Object[])new Object[]{memberNameOrId, Integer.toString(createdGatewayReceiver.getPort())})));
        }
        catch (IllegalStateException e) {
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, (Object)e, e.getMessage()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, (Object)e, e.getMessage()));
        }
    }

    GatewayReceiver createGatewayReceiver(Cache cache, GatewayReceiverConfig gatewayReceiverConfig) {
        GatewayReceiverRealizer receiverRealizer = new GatewayReceiverRealizer();
        receiverRealizer.create(gatewayReceiverConfig, (InternalCache)cache);
        return (GatewayReceiver)cache.getGatewayReceivers().iterator().next();
    }

    boolean gatewayReceiverExists(Cache cache) {
        return cache.getGatewayReceivers() != null && !cache.getGatewayReceivers().isEmpty();
    }
}

