/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HyphenFormatter {
    private static final String OPTION_PATTERN = "--[a-zA-Z]+[a-zA-Z\\-]*=*";
    private static final String QUOTE = "\"";
    private static final String EQUAL_HYPHEN = "=-";
    private static final String EQUAL = "=";
    private static final String SPACE = " ";
    private StringBuilder formatted;

    public String formatCommand(String command) {
        if (!this.containsOption(command)) {
            return command;
        }
        this.formatted = new StringBuilder();
        List<String> strings = this.split(command);
        for (String string : strings) {
            if (string.contains(EQUAL_HYPHEN)) {
                int indexOfEquals = string.indexOf(EQUAL);
                this.formatted.append(string, 0, indexOfEquals + 1);
                this.formatted.append(QUOTE);
                this.formatted.append(string.substring(indexOfEquals + 1));
                this.formatted.append(QUOTE);
            } else {
                this.formatted.append(string);
            }
            this.formatted.append(SPACE);
        }
        return this.formatted.toString().trim();
    }

    boolean containsOption(String cmd) {
        return Pattern.compile(OPTION_PATTERN).matcher(cmd).find();
    }

    private List<String> split(String cmd) {
        ArrayList<String> strings = new ArrayList<String>();
        Matcher matcher = Pattern.compile(OPTION_PATTERN).matcher(cmd);
        int index = 0;
        while (matcher.find()) {
            if (matcher.start() > index) {
                String option = cmd.substring(index, matcher.start()).trim();
                strings.add(option);
            }
            index = matcher.start();
        }
        String lastOne = cmd.substring(index);
        if (lastOne != null) {
            strings.add(lastOne);
        }
        return strings;
    }
}

