/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.MetalakeMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.MetalakeMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.MetalakePO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class MetalakeMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, MetalakeMetaBaseSQLProvider> METALAKE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new MetalakeMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new MetalakeMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new MetalakeMetaPostgreSQLProvider());

    public static MetalakeMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return METALAKE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public String listMetalakePOs() {
        return MetalakeMetaSQLProviderFactory.getProvider().listMetalakePOs();
    }

    public static String selectMetalakeMetaByName(@Param(value="metalakeName") String metalakeName) {
        return MetalakeMetaSQLProviderFactory.getProvider().selectMetalakeMetaByName(metalakeName);
    }

    public static String selectMetalakeMetaById(@Param(value="metalakeId") Long metalakeId) {
        return MetalakeMetaSQLProviderFactory.getProvider().selectMetalakeMetaById(metalakeId);
    }

    public static String selectMetalakeIdMetaByName(@Param(value="metalakeName") String metalakeName) {
        return MetalakeMetaSQLProviderFactory.getProvider().selectMetalakeIdMetaByName(metalakeName);
    }

    public static String listMetalakePOsByMetalakeIds(@Param(value="metalakeIds") List<Long> metalakeIds) {
        return MetalakeMetaSQLProviderFactory.getProvider().listMetalakePOsByMetalakeIds(metalakeIds);
    }

    public static String insertMetalakeMeta(@Param(value="metalakeMeta") MetalakePO metalakePO) {
        return MetalakeMetaSQLProviderFactory.getProvider().insertMetalakeMeta(metalakePO);
    }

    public static String insertMetalakeMetaOnDuplicateKeyUpdate(@Param(value="metalakeMeta") MetalakePO metalakePO) {
        return MetalakeMetaSQLProviderFactory.getProvider().insertMetalakeMetaOnDuplicateKeyUpdate(metalakePO);
    }

    public static String updateMetalakeMeta(@Param(value="newMetalakeMeta") MetalakePO newMetalakePO, @Param(value="oldMetalakeMeta") MetalakePO oldMetalakePO) {
        return MetalakeMetaSQLProviderFactory.getProvider().updateMetalakeMeta(newMetalakePO, oldMetalakePO);
    }

    public static String softDeleteMetalakeMetaByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return MetalakeMetaSQLProviderFactory.getProvider().softDeleteMetalakeMetaByMetalakeId(metalakeId);
    }

    public static String deleteMetalakeMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return MetalakeMetaSQLProviderFactory.getProvider().deleteMetalakeMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class MetalakeMetaH2Provider
    extends MetalakeMetaBaseSQLProvider {
        MetalakeMetaH2Provider() {
        }
    }

    static class MetalakeMetaMySQLProvider
    extends MetalakeMetaBaseSQLProvider {
        MetalakeMetaMySQLProvider() {
        }
    }
}

