/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import java.util.List;
import org.apache.gravitino.storage.relational.mapper.provider.base.SecurableObjectBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.ibatis.annotations.Param;

public class SecurableObjectPostgreSQLProvider
extends SecurableObjectBaseSQLProvider {
    @Override
    public String batchSoftDeleteSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> securableObjectPOs) {
        return "<script>UPDATE role_meta_securable_object SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE FALSE <foreach collection='securableObjects' item='item' separator=' '> OR (metadata_object_id = #{item.metadataObjectId} AND role_id = #{item.roleId} AND deleted_at = 0 AND privilege_names = #{item.privilegeNames} AND privilege_conditions = #{item.privilegeConditions})</foreach></script>";
    }

    @Override
    public String softDeleteSecurableObjectsByRoleId(Long roleId) {
        return "UPDATE role_meta_securable_object SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE role_id = #{roleId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteSecurableObjectsByMetalakeId(Long metalakeId) {
        return "UPDATE role_meta_securable_object ob SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE exists (SELECT * from role_meta ro WHERE ro.metalake_id = #{metalakeId} AND ro.role_id = ob.role_id AND ro.deleted_at = 0) AND ob.deleted_at = 0";
    }

    @Override
    public String softDeleteObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return "UPDATE role_meta_securable_object SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE metadata_object_id = #{metadataObjectId} AND deleted_at = 0 AND type = #{metadataObjectType}";
    }

    @Override
    public String softDeleteObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE role_meta_securable_object sect SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE sect.deleted_at = 0 AND EXISTS ( SELECT ct.catalog_id FROM catalog_meta ct WHERE ct.catalog_id = #{catalogId} AND ct.catalog_id = sect.metadata_object_id AND sect.type = 'CATALOG' UNION  SELECT st.catalog_id FROM schema_meta st WHERE st.catalog_id = #{catalogId} AND st.schema_id = sect.metadata_object_id AND sect.type = 'SCHEMA' UNION  SELECT tt.catalog_id FROM topic_meta tt WHERE tt.catalog_id = #{catalogId}  AND tt.topic_id = sect.metadata_object_id AND sect.type = 'TOPIC' UNION  SELECT tat.catalog_id FROM table_meta tat WHERE tat.catalog_id = #{catalogId}  AND tat.table_id = sect.metadata_object_id AND sect.type = 'TABLE' UNION  SELECT ft.catalog_id FROM fileset_meta ft WHERE ft.catalog_id = #{catalogId}  AND ft.fileset_id = sect.metadata_object_id AND sect.type = 'FILESET' UNION  SELECT mt.catalog_id FROM model_meta mt WHERE mt.catalog_id = #{catalogId} AND mt.model_id = sect.metadata_object_id AND sect.type = 'MODEL')";
    }

    @Override
    public String softDeleteObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE role_meta_securable_object sect SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE sect.deleted_at = 0 AND EXISTS ( SELECT st.schema_id FROM schema_meta st WHERE st.schema_id = #{schemaId}  AND st.schema_id = sect.metadata_object_id AND sect.type = 'SCHEMA' UNION  SELECT tt.schema_id FROM topic_meta tt WHERE tt.schema_id = #{schemaId} AND tt.topic_id = sect.metadata_object_id AND sect.type = 'TOPIC' UNION  SELECT tat.schema_id FROM table_meta tat WHERE tat.schema_id = #{schemaId}  AND tat.table_id = sect.metadata_object_id AND sect.type = 'TABLE' UNION  SELECT ft.schema_id FROM fileset_meta ft WHERE ft.schema_id = #{schemaId} AND ft.fileset_id = sect.metadata_object_id AND sect.type = 'FILESET' UNION  SELECT mt.schema_id FROM model_meta mt WHERE mt.schema_id = #{schemaId} AND  mt.model_id = sect.metadata_object_id AND sect.type = 'MODEL')";
    }

    @Override
    public String deleteSecurableObjectsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM role_meta_securable_object WHERE id IN (SELECT id FROM role_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

