/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Throwables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

public class DynFields {
    private DynFields() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class MakeFieldAccessible
    implements PrivilegedAction<Void> {
        private final Field hidden;

        MakeFieldAccessible(Field hidden) {
            this.hidden = hidden;
        }

        @Override
        public Void run() {
            this.hidden.setAccessible(true);
            return null;
        }
    }

    public static class Builder {
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private UnboundField<?> field = null;
        private final Set<String> candidates = Sets.newHashSet();
        private boolean defaultAlwaysNull = false;

        private Builder() {
        }

        public Builder loader(ClassLoader newLoader) {
            this.loader = newLoader;
            return this;
        }

        public Builder defaultAlwaysNull() {
            this.defaultAlwaysNull = true;
            return this;
        }

        public Builder impl(String className, String fieldName) {
            if (this.field != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.impl(targetClass, fieldName);
            }
            catch (ClassNotFoundException e) {
                this.candidates.add(className + "." + fieldName);
            }
            return this;
        }

        public Builder impl(Class<?> targetClass, String fieldName) {
            if (this.field != null || targetClass == null) {
                return this;
            }
            try {
                this.field = new UnboundField(targetClass.getField(fieldName), fieldName);
            }
            catch (NoSuchFieldException e) {
                this.candidates.add(targetClass.getName() + "." + fieldName);
            }
            return this;
        }

        public Builder hiddenImpl(String className, String fieldName) {
            if (this.field != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.hiddenImpl(targetClass, fieldName);
            }
            catch (ClassNotFoundException e) {
                this.candidates.add(className + "." + fieldName);
            }
            return this;
        }

        public Builder hiddenImpl(Class<?> targetClass, String fieldName) {
            if (this.field != null || targetClass == null) {
                return this;
            }
            try {
                Field hidden = targetClass.getDeclaredField(fieldName);
                AccessController.doPrivileged(new MakeFieldAccessible(hidden));
                this.field = new UnboundField(hidden, fieldName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                this.candidates.add(targetClass.getName() + "." + fieldName);
            }
            return this;
        }

        public <T> UnboundField<T> buildChecked() throws NoSuchFieldException {
            if (this.field != null) {
                return this.field;
            }
            if (this.defaultAlwaysNull) {
                return AlwaysNull.INSTANCE;
            }
            throw new NoSuchFieldException("Cannot find field from candidates: " + Joiner.on((String)", ").join(this.candidates));
        }

        public <T> BoundField<T> buildChecked(Object target) throws NoSuchFieldException {
            return this.buildChecked().bind(target);
        }

        public <T> UnboundField<T> build() {
            if (this.field != null) {
                return this.field;
            }
            if (this.defaultAlwaysNull) {
                return AlwaysNull.INSTANCE;
            }
            throw new RuntimeException("Cannot find field from candidates: " + Joiner.on((String)", ").join(this.candidates));
        }

        public <T> BoundField<T> build(Object target) {
            return this.build().bind(target);
        }

        @Deprecated
        public <T> StaticField<T> buildStaticChecked() throws NoSuchFieldException {
            return this.buildChecked().asStatic();
        }

        public <T> StaticField<T> buildStatic() {
            return this.build().asStatic();
        }
    }

    public static class BoundField<T> {
        private final UnboundField<T> field;
        private final Object target;

        private BoundField(UnboundField<T> field, Object target) {
            this.field = field;
            this.target = target;
        }

        public T get() {
            return this.field.get(this.target);
        }

        public void set(T value) {
            this.field.set(this.target, value);
        }
    }

    public static class StaticField<T> {
        private final UnboundField<T> field;

        private StaticField(UnboundField<T> field) {
            this.field = field;
        }

        public T get() {
            return this.field.get(null);
        }

        public void set(T value) {
            this.field.set(null, value);
        }
    }

    private static class AlwaysNull
    extends UnboundField<Void> {
        private static final AlwaysNull INSTANCE = new AlwaysNull();

        private AlwaysNull() {
            super(null, "AlwaysNull");
        }

        @Override
        public Void get(Object target) {
            return null;
        }

        @Override
        public void set(Object target, Void value) {
        }

        @Override
        public String toString() {
            return "Field(AlwaysNull)";
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public boolean isAlwaysNull() {
            return true;
        }
    }

    public static class UnboundField<T> {
        private final Field field;
        private final String name;

        private UnboundField(Field field, String name) {
            this.field = field;
            this.name = name;
        }

        public T get(Object target) {
            try {
                return (T)this.field.get(target);
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public void set(Object target, T value) {
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("class", (Object)this.field.getDeclaringClass().toString()).add("name", (Object)this.name).add("type", this.field.getType()).toString();
        }

        public BoundField<T> bind(Object target) {
            Preconditions.checkState((!this.isStatic() || this == AlwaysNull.INSTANCE ? 1 : 0) != 0, (String)"Cannot bind static field %s", (Object)this.name);
            Preconditions.checkArgument((boolean)this.field.getDeclaringClass().isAssignableFrom(target.getClass()), (String)"Cannot bind field %s to instance of %s", (Object)this.name, target.getClass());
            return new BoundField(this, target);
        }

        public StaticField<T> asStatic() {
            Preconditions.checkState((boolean)this.isStatic(), (String)"Field %s is not static", (Object)this.name);
            return new StaticField(this);
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.field.getModifiers());
        }

        public boolean isAlwaysNull() {
            return this == AlwaysNull.INSTANCE;
        }
    }
}

