/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.actions.ImmutableRewritePositionDeleteFiles;
import org.apache.iceberg.actions.RewritePositionDeleteFiles;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class RewritePositionDeletesGroup {
    private final RewritePositionDeleteFiles.FileGroupInfo info;
    private final List<PositionDeletesScanTask> tasks;
    private final long maxRewrittenDataSequenceNumber;
    private Set<DeleteFile> addedDeleteFiles = Collections.emptySet();

    public RewritePositionDeletesGroup(RewritePositionDeleteFiles.FileGroupInfo info, List<PositionDeletesScanTask> tasks) {
        Preconditions.checkArgument((!tasks.isEmpty() ? 1 : 0) != 0, (Object)"Tasks must not be empty");
        this.info = info;
        this.tasks = tasks;
        this.maxRewrittenDataSequenceNumber = tasks.stream().mapToLong(t -> ((DeleteFile)t.file()).dataSequenceNumber()).max().getAsLong();
    }

    public RewritePositionDeleteFiles.FileGroupInfo info() {
        return this.info;
    }

    public List<PositionDeletesScanTask> tasks() {
        return this.tasks;
    }

    public void setOutputFiles(Set<DeleteFile> files) {
        this.addedDeleteFiles = files;
    }

    public long maxRewrittenDataSequenceNumber() {
        return this.maxRewrittenDataSequenceNumber;
    }

    public Set<DeleteFile> rewrittenDeleteFiles() {
        return this.tasks().stream().map(ContentScanTask::file).collect(Collectors.toSet());
    }

    public Set<DeleteFile> addedDeleteFiles() {
        return this.addedDeleteFiles;
    }

    public RewritePositionDeleteFiles.FileGroupRewriteResult asResult() {
        Preconditions.checkState((this.addedDeleteFiles != null ? 1 : 0) != 0, (Object)"Cannot get result, Group was never rewritten");
        return ImmutableRewritePositionDeleteFiles.FileGroupRewriteResult.builder().info(this.info).addedDeleteFilesCount(this.addedDeleteFiles.size()).rewrittenDeleteFilesCount(this.tasks.size()).rewrittenBytesCount(this.rewrittenBytes()).addedBytesCount(this.addedBytes()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("info", (Object)this.info).add("numRewrittenPositionDeleteFiles", this.tasks.size()).add("numAddedPositionDeleteFiles", (Object)(this.addedDeleteFiles == null ? "Rewrite Incomplete" : Integer.toString(this.addedDeleteFiles.size()))).add("numAddedBytes", this.addedBytes()).add("numRewrittenBytes", this.rewrittenBytes()).toString();
    }

    public long rewrittenBytes() {
        return this.tasks.stream().mapToLong(ContentScanTask::length).sum();
    }

    public long addedBytes() {
        return this.addedDeleteFiles.stream().mapToLong(ContentFile::fileSizeInBytes).sum();
    }

    public int numRewrittenDeleteFiles() {
        return this.tasks.size();
    }

    public static Comparator<RewritePositionDeletesGroup> comparator(RewriteJobOrder order) {
        switch (order) {
            case BYTES_ASC: {
                return Comparator.comparing(RewritePositionDeletesGroup::rewrittenBytes);
            }
            case BYTES_DESC: {
                return Comparator.comparing(RewritePositionDeletesGroup::rewrittenBytes, Comparator.reverseOrder());
            }
            case FILES_ASC: {
                return Comparator.comparing(RewritePositionDeletesGroup::numRewrittenDeleteFiles);
            }
            case FILES_DESC: {
                return Comparator.comparing(RewritePositionDeletesGroup::numRewrittenDeleteFiles, Comparator.reverseOrder());
            }
        }
        return (fileGroupOne, fileGroupTwo) -> 0;
    }
}

