/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.model;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface ModelChange {
    public static ModelChange rename(String newName) {
        return new RenameModel(newName);
    }

    public static ModelChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static ModelChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static ModelChange updateComment(String newComment) {
        return new UpdateComment(newComment);
    }

    public static final class UpdateComment
    implements ModelChange {
        private final String newComment;

        public UpdateComment(String newComment) {
            this.newComment = newComment;
        }

        public String newComment() {
            return this.newComment;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof UpdateComment)) {
                return false;
            }
            UpdateComment other = (UpdateComment)obj;
            return Objects.equals(this.newComment, other.newComment);
        }

        public int hashCode() {
            return Objects.hash(this.newComment);
        }

        public String toString() {
            return "UpdateComment " + this.newComment;
        }
    }

    public static final class RemoveProperty
    implements ModelChange {
        private final String property;

        public RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RemoveProperty)) {
                return false;
            }
            RemoveProperty other = (RemoveProperty)obj;
            return Objects.equals(this.property, other.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "RemoveProperty " + this.property;
        }
    }

    public static final class SetProperty
    implements ModelChange {
        private final String property;
        private final String value;

        public SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SetProperty)) {
                return false;
            }
            SetProperty other = (SetProperty)obj;
            return Objects.equals(this.property, other.property) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class RenameModel
    implements ModelChange {
        private final String newName;

        public RenameModel(String newName) {
            this.newName = newName;
        }

        public String newName() {
            return this.newName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RenameModel)) {
                return false;
            }
            RenameModel other = (RenameModel)obj;
            return Objects.equals(this.newName, other.newName);
        }

        public int hashCode() {
            return Objects.hash(this.newName);
        }

        public String toString() {
            return "RenameModel " + this.newName;
        }
    }
}

