/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system.storedprocdure;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorManager;
import org.apache.gravitino.trino.connector.system.storedprocdure.GravitinoStoredProcedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCatalogStoredProcedure
extends GravitinoStoredProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(CreateCatalogStoredProcedure.class);
    private final CatalogConnectorManager catalogConnectorManager;
    private final String metalake;

    public CreateCatalogStoredProcedure(CatalogConnectorManager catalogConnectorManager, String metalake) {
        this.catalogConnectorManager = catalogConnectorManager;
        this.metalake = metalake;
    }

    @Override
    public Procedure createStoredProcedure() throws NoSuchMethodException, IllegalAccessException {
        MethodHandle createCatalog = MethodHandles.lookup().unreflect(CreateCatalogStoredProcedure.class.getMethod("createCatalog", String.class, String.class, Map.class, Boolean.TYPE)).bindTo(this);
        List<Procedure.Argument> arguments = List.of(new Procedure.Argument("CATALOG", (Type)VarcharType.VARCHAR), new Procedure.Argument("PROVIDER", (Type)VarcharType.VARCHAR), new Procedure.Argument("PROPERTIES", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, new TypeOperators())), new Procedure.Argument("IGNORE_EXIST", (Type)BooleanType.BOOLEAN, false, (Object)false));
        return new Procedure("system", "create_catalog", arguments, createCatalog);
    }

    public void createCatalog(String catalogName, String provider, Map<String, String> properties, boolean ignoreExist) {
        boolean exists = this.catalogConnectorManager.catalogConnectorExist(this.catalogConnectorManager.getTrinoCatalogName(this.metalake, catalogName));
        if (exists) {
            if (!ignoreExist) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_ALREADY_EXISTS, String.format("Catalog %s already exists.", NameIdentifier.of((String[])new String[]{this.metalake, catalogName})));
            }
            return;
        }
        try {
            this.catalogConnectorManager.getMetalake(this.metalake).createCatalog(catalogName, Catalog.Type.RELATIONAL, provider, "Trino created", properties);
            this.catalogConnectorManager.loadMetalakeSync();
            if (!this.catalogConnectorManager.catalogConnectorExist(this.catalogConnectorManager.getTrinoCatalogName(this.metalake, catalogName))) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_OPERATION_FAILED, "Create catalog failed due to the loading process fails");
            }
            LOG.info("Create catalog {} in metalake {} successfully.", (Object)catalogName, (Object)this.metalake);
        }
        catch (NoSuchMetalakeException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_METALAKE_NOT_EXISTS, "Metalake " + this.metalake + " not exists.");
        }
        catch (CatalogAlreadyExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_ALREADY_EXISTS, "Catalog " + String.valueOf(NameIdentifier.of((String[])new String[]{this.metalake, catalogName})) + " already exists in the server.");
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_OPERATION, "Create catalog failed. " + (StringUtils.isEmpty((CharSequence)e.getMessage()) ? "" : e.getMessage()), (Throwable)e);
        }
    }
}

