/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.HashMap;
import java.util.Set;
import org.apache.gravitino.trino.connector.GravitinoConfig;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorContext;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorFactory;
import org.apache.gravitino.trino.connector.catalog.hive.HiveConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.postgresql.PostgreSQLConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.trino.TrinoClusterConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.memory.MemoryConnectorAdapter;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogConnectorFactory
implements CatalogConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCatalogConnectorFactory.class);
    private static final String HIVE_CONNECTOR_PROVIDER_NAME = "hive";
    private static final String ICEBERG_CONNECTOR_PROVIDER_NAME = "lakehouse-iceberg";
    private static final String MEMORY_CONNECTOR_PROVIDER_NAME = "memory";
    private static final String MYSQL_CONNECTOR_PROVIDER_NAME = "jdbc-mysql";
    private static final String POSTGRESQL_CONNECTOR_PROVIDER_NAME = "jdbc-postgresql";
    private static final String TRINO_CLUSTER_CONNECTOR_PROVIDER_NAME = "trino-cluster";
    protected final HashMap<String, CatalogConnectorContext.Builder> catalogBuilders = new HashMap();
    protected final String region;

    public DefaultCatalogConnectorFactory(GravitinoConfig config) {
        this.region = config.getRegion();
        this.catalogBuilders.put(HIVE_CONNECTOR_PROVIDER_NAME, new CatalogConnectorContext.Builder(new HiveConnectorAdapter()));
        this.catalogBuilders.put(MEMORY_CONNECTOR_PROVIDER_NAME, new CatalogConnectorContext.Builder(new MemoryConnectorAdapter()));
        this.catalogBuilders.put(ICEBERG_CONNECTOR_PROVIDER_NAME, new CatalogConnectorContext.Builder(new IcebergConnectorAdapter()));
        this.catalogBuilders.put(MYSQL_CONNECTOR_PROVIDER_NAME, new CatalogConnectorContext.Builder(new MySQLConnectorAdapter()));
        this.catalogBuilders.put(POSTGRESQL_CONNECTOR_PROVIDER_NAME, new CatalogConnectorContext.Builder(new PostgreSQLConnectorAdapter()));
        this.catalogBuilders.put(TRINO_CLUSTER_CONNECTOR_PROVIDER_NAME, new CatalogConnectorContext.Builder(new TrinoClusterConnectorAdapter()));
        LOG.info("Start the DefaultCatalogConnectorFactory");
    }

    @Override
    public Set<String> getSupportedCatalogProviders() {
        return this.catalogBuilders.keySet();
    }

    @Override
    public CatalogConnectorContext.Builder createCatalogConnectorContextBuilder(GravitinoCatalog catalog) {
        CatalogConnectorContext.Builder builder;
        String catalogProvider = catalog.getProvider();
        if (!catalog.isSameRegion(this.region)) {
            catalogProvider = TRINO_CLUSTER_CONNECTOR_PROVIDER_NAME;
        }
        if ((builder = this.catalogBuilders.get(catalogProvider)) == null) {
            String message = String.format("Unsupported catalog provider %s.", catalogProvider);
            LOG.error(message);
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_CATALOG_PROVIDER, message);
        }
        return builder.clone(catalog);
    }
}

