/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import java.util.Arrays;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

@JsonDeserialize(builder=StatisticsDropRequestBuilder.class)
public class StatisticsDropRequest
implements RESTRequest {
    @JsonProperty(value="names")
    String[] names;

    public StatisticsDropRequest(String[] names) {
        this.names = names;
    }

    public StatisticsDropRequest() {
        this(null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.names != null && this.names.length > 0, "\"names\" must not be null or empty");
        for (String name : this.names) {
            Preconditions.checkArgument(StringUtils.isNotBlank(name), "Each name must be a non-empty string");
        }
    }

    public static StatisticsDropRequestBuilder builder() {
        return new StatisticsDropRequestBuilder();
    }

    public String[] getNames() {
        return this.names;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsDropRequest)) {
            return false;
        }
        StatisticsDropRequest other = (StatisticsDropRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getNames(), other.getNames());
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticsDropRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getNames());
        return result;
    }

    public String toString() {
        return "StatisticsDropRequest(names=" + Arrays.deepToString(this.getNames()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class StatisticsDropRequestBuilder {
        private String[] names;

        StatisticsDropRequestBuilder() {
        }

        @JsonProperty(value="names")
        public StatisticsDropRequestBuilder names(String[] names) {
            this.names = names;
            return this;
        }

        public StatisticsDropRequest build() {
            return new StatisticsDropRequest(this.names);
        }

        public String toString() {
            return "StatisticsDropRequest.StatisticsDropRequestBuilder(names=" + Arrays.deepToString(this.names) + ")";
        }
    }
}

