/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions.distributions;

import java.util.Arrays;
import java.util.Objects;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Strategy;

public class Distributions {
    public static final int AUTO = -1;
    public static final Distribution NONE = new DistributionImpl(Strategy.NONE, 0, Expression.EMPTY_EXPRESSION);
    public static final Distribution HASH = new DistributionImpl(Strategy.HASH, 0, Expression.EMPTY_EXPRESSION);
    public static final Distribution RANGE = new DistributionImpl(Strategy.RANGE, 0, Expression.EMPTY_EXPRESSION);

    public static Distribution even(int number, Expression ... expressions) {
        return new DistributionImpl(Strategy.EVEN, number, expressions);
    }

    public static Distribution hash(int number, Expression ... expressions) {
        return new DistributionImpl(Strategy.HASH, number, expressions);
    }

    public static Distribution of(Strategy strategy, int number, Expression ... expressions) {
        return new DistributionImpl(strategy, number, expressions);
    }

    public static Distribution auto(Strategy strategy, Expression ... expressions) {
        return new DistributionImpl(strategy, -1, expressions);
    }

    public static Distribution fields(Strategy strategy, int number, String[] ... fieldNames) {
        Expression[] expressions = (Expression[])Arrays.stream(fieldNames).map(NamedReference::field).toArray(Expression[]::new);
        return Distributions.of(strategy, number, expressions);
    }

    private Distributions() {
    }

    public static final class DistributionImpl
    implements Distribution {
        private final Strategy strategy;
        private final int number;
        private final Expression[] expressions;

        private DistributionImpl(Strategy strategy, int number, Expression[] expressions) {
            this.strategy = strategy;
            this.number = number;
            this.expressions = expressions;
        }

        @Override
        public Strategy strategy() {
            return this.strategy;
        }

        @Override
        public int number() {
            return this.number;
        }

        @Override
        public Expression[] expressions() {
            return this.expressions;
        }

        public String toString() {
            return "DistributionImpl{strategy=" + String.valueOf((Object)this.strategy) + ", number=" + this.number + ", expressions=" + Arrays.toString(this.expressions) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistributionImpl that = (DistributionImpl)o;
            return this.number == that.number && this.strategy == that.strategy && Arrays.equals(this.expressions, that.expressions);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.strategy, this.number});
            result = 31 * result + Arrays.hashCode(this.expressions);
            return result;
        }

        public static class Builder {
            private Strategy strategy;
            private int number;
            private Expression[] expressions;

            public Builder withStrategy(Strategy strategy) {
                this.strategy = strategy;
                return this;
            }

            public Builder withNumber(int number) {
                this.number = number;
                return this;
            }

            public Builder withExpressions(Expression[] expressions) {
                this.expressions = expressions;
                return this;
            }

            public Distribution build() {
                return new DistributionImpl(this.strategy, this.number, this.expressions);
            }
        }
    }
}

