/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.internal;

import io.opentelemetry.context.Context;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientResendCount;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import java.io.IOException;
import java.time.Instant;

public final class ConnectionErrorSpanInterceptor
implements Interceptor {
    private final Instrumenter<Request, Response> instrumenter;

    public ConnectionErrorSpanInterceptor(Instrumenter<Request, Response> instrumenter) {
        this.instrumenter = instrumenter;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Context parentContext = Context.current();
        Response response = null;
        Throwable error = null;
        Instant startTime = Instant.now();
        try {
            Response response2 = response = chain.proceed(request);
            return response2;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (HttpClientResendCount.get(parentContext) == 0 && this.instrumenter.shouldStart(parentContext, request)) {
                InstrumenterUtil.startAndEnd(this.instrumenter, parentContext, request, response, error, startTime, Instant.now());
            }
        }
    }
}

