/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.RecordComponentNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.classgen.AnnotationVisitor;
import org.codehaus.groovy.control.AnnotationConstantsVisitor;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

public class ExtendedVerifier
extends ClassCodeVisitorSupport {
    @Deprecated(forRemoval=true, since="5.0.0")
    public static final String JVM_ERROR_MESSAGE = "Please make sure you are running on a JVM >= 1.5";
    private ClassNode currentClass;
    private final SourceUnit source;
    private final Map<String, Boolean> repeatableCache = new HashMap<String, Boolean>();

    public ExtendedVerifier(SourceUnit sourceUnit) {
        this.source = sourceUnit;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode node) {
        AnnotationConstantsVisitor acv = new AnnotationConstantsVisitor();
        acv.visitClass(node, this.source);
        this.currentClass = node;
        PackageNode packageNode = node.getPackage();
        if (packageNode != null) {
            this.visitAnnotations(packageNode, 128);
        }
        if (node.isAnnotationDefinition()) {
            this.visitAnnotations(node, 64);
        } else {
            this.visitAnnotations(node, 65);
            this.visitGenericsTypeAnnotations(node);
        }
        this.visitTypeAnnotations(node.getUnresolvedSuperClass());
        for (ClassNode anInterface : node.getInterfaces()) {
            this.visitTypeAnnotations(anInterface);
        }
        if (node.isRecord()) {
            for (RecordComponentNode recordComponent : node.getRecordComponents()) {
                this.visitAnnotations(recordComponent, 1024);
                this.visitTypeAnnotations(recordComponent.getType());
                this.extractTypeUseAnnotations(recordComponent.getAnnotations(), recordComponent.getType(), 1024);
            }
        }
        node.visitContents(this);
    }

    @Override
    public void visitField(FieldNode node) {
        this.visitAnnotations(node, 8);
        if (!node.isStatic() && this.currentClass.isRecord()) {
            return;
        }
        this.visitTypeAnnotations(node.getType());
        this.extractTypeUseAnnotations(node.getAnnotations(), node.getType(), 8);
    }

    @Override
    public void visitProperty(PropertyNode node) {
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.visitAnnotations(expression, 32);
        if (expression.isMultipleAssignmentDeclaration()) {
            expression.getTupleExpression().forEach(e -> this.visitTypeAnnotations(e.getType()));
        } else {
            ClassNode type = expression.getLeftExpression().getType();
            this.visitTypeAnnotations(type);
            this.extractTypeUseAnnotations(expression.getAnnotations(), type, 32);
        }
        expression.getRightExpression().visit(this);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression expression) {
        if (!expression.isSpecialCall()) {
            this.visitTypeAnnotations(expression.getType());
        }
        super.visitConstructorCallExpression(expression);
    }

    private void visitConstructorOrMethod(MethodNode node) {
        Statement code;
        this.visitGenericsTypeAnnotations(node);
        for (Parameter parameter : node.getParameters()) {
            this.visitAnnotations(parameter, 16);
            this.visitTypeAnnotations(parameter.getType());
            this.extractTypeUseAnnotations(parameter.getAnnotations(), parameter.getType(), 16);
        }
        if (node.getExceptions() != null) {
            for (AnnotatedNode annotatedNode : node.getExceptions()) {
                this.visitTypeAnnotations((ClassNode)annotatedNode);
            }
        }
        if (this.currentClass.isAnnotationDefinition() && !node.isStaticConstructor()) {
            ReturnStatement code2;
            ErrorCollector errorCollector = new ErrorCollector(this.source.getConfiguration());
            AnnotationVisitor visitor = new AnnotationVisitor(this.source, errorCollector);
            visitor.setReportClass(this.currentClass);
            visitor.checkReturnType(node.getReturnType(), node);
            if (node.getParameters().length > 0) {
                this.addError("Annotation members may not have parameters.", node.getParameters()[0]);
            }
            if (node.getExceptions().length > 0) {
                this.addError("Annotation members may not have a throws clause.", node.getExceptions()[0]);
            }
            if ((code2 = (ReturnStatement)node.getCode()) != null) {
                visitor.visitExpression(node.getName(), code2.getExpression(), node.getReturnType());
                visitor.checkCircularReference(this.currentClass, node.getReturnType(), code2.getExpression());
            }
            this.source.getErrorCollector().addCollectorContents(errorCollector);
        }
        if ((code = node.getCode()) != null) {
            code.visit(this);
        }
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        this.visitAnnotations(node, 2);
        this.visitConstructorOrMethod(node);
        if (!node.getReturnType().isRedirectNode() && node.getAnnotations().stream().anyMatch(anno -> anno.isTargetAllowed(512))) {
            node.setReturnType(node.getReturnType().getPlainNodeReference(false));
        }
        this.extractTypeUseAnnotations(node.getAnnotations(), node.getReturnType(), 2);
    }

    @Override
    public void visitMethod(MethodNode node) {
        this.visitAnnotations(node, 4);
        this.visitTypeAnnotations(node.getReturnType());
        this.visitConstructorOrMethod(node);
        this.extractTypeUseAnnotations(node.getAnnotations(), node.getReturnType(), 4);
    }

    private void visitTypeAnnotations(ClassNode node) {
        if ((node.isRedirectNode() || node.isPrimaryClassNode()) && !Boolean.TRUE.equals(node.putNodeMetaData("EXTENDED_VERIFIER_SEEN", Boolean.TRUE))) {
            this.visitAnnotations(node, node.getTypeAnnotations(), node.isGenericsPlaceHolder() ? 256 : 512);
            if (node.isArray()) {
                this.visitTypeAnnotations(node.getComponentType());
            } else {
                this.visitGenericsTypeAnnotations(node);
            }
        }
    }

    private void visitGenericsTypeAnnotations(ClassNode node) {
        GenericsType[] genericsTypes = node.getGenericsTypes();
        if (node.isUsingGenerics() && genericsTypes != null) {
            this.visitGenericsTypeAnnotations(genericsTypes);
        }
    }

    private void visitGenericsTypeAnnotations(MethodNode node) {
        GenericsType[] genericsTypes = node.getGenericsTypes();
        if (genericsTypes != null) {
            this.visitGenericsTypeAnnotations(genericsTypes);
        }
    }

    private void visitGenericsTypeAnnotations(GenericsType[] genericsTypes) {
        for (GenericsType gt : genericsTypes) {
            this.visitTypeAnnotations(gt.getType());
            if (gt.getLowerBound() != null) {
                this.visitTypeAnnotations(gt.getLowerBound());
            }
            if (gt.getUpperBounds() == null) continue;
            for (ClassNode ub : gt.getUpperBounds()) {
                this.visitTypeAnnotations(ub);
            }
        }
    }

    private void extractTypeUseAnnotations(List<AnnotationNode> mixed, ClassNode targetType, int keepTarget) {
        ArrayList<AnnotationNode> typeUseAnnos = new ArrayList<AnnotationNode>();
        for (AnnotationNode anno : mixed) {
            if (!anno.isTargetAllowed(512)) continue;
            typeUseAnnos.add(anno);
        }
        if (!typeUseAnnos.isEmpty()) {
            while (targetType.isArray()) {
                targetType = targetType.getComponentType();
            }
            targetType.addTypeAnnotations(typeUseAnnos);
            for (AnnotationNode anno : typeUseAnnos) {
                if (anno.isTargetAllowed(keepTarget)) continue;
                mixed.remove(anno);
            }
        }
    }

    protected void visitAnnotations(AnnotatedNode node, int target) {
        this.visitAnnotations(node, node.getAnnotations(), target);
    }

    private void visitAnnotations(AnnotatedNode node, List<AnnotationNode> annotations, int target) {
        if (annotations.isEmpty()) {
            return;
        }
        this.currentClass.setAnnotated(true);
        LinkedHashMap<String, List<AnnotationNode>> nonSourceAnnotations = new LinkedHashMap<String, List<AnnotationNode>>();
        boolean skippable = Boolean.TRUE.equals(node.getNodeMetaData("_SKIPPABLE_ANNOTATIONS"));
        Iterator<AnnotationNode> iterator = annotations.iterator();
        while (iterator.hasNext()) {
            boolean isTargetAnnotation;
            AnnotationNode unvisited = iterator.next();
            ErrorCollector errorCollector = new ErrorCollector(this.source.getConfiguration());
            AnnotationVisitor visitor = new AnnotationVisitor(this.source, errorCollector);
            AnnotationNode visited = visitor.visit(unvisited);
            this.source.getErrorCollector().addCollectorContents(errorCollector);
            String name = visited.getClassNode().getName();
            if (skippable && this.shouldSkip(node, visited)) {
                iterator.remove();
                continue;
            }
            if (!visited.hasSourceRetention()) {
                ArrayList<AnnotationNode> seen = (ArrayList<AnnotationNode>)nonSourceAnnotations.get(name);
                if (seen == null) {
                    seen = new ArrayList<AnnotationNode>();
                } else if (!this.isRepeatable(visited)) {
                    this.addError("Cannot specify duplicate annotation on the same member : " + name, visited);
                }
                seen.add(visited);
                nonSourceAnnotations.put(name, seen);
            }
            if (!((isTargetAnnotation = "java.lang.annotation.Target".equals(name)) || visited.isTargetAllowed(target) || this.isTypeUseScenario(visited, target))) {
                this.addError("Annotation @" + name + " is not allowed on element " + AnnotationNode.targetToName(target), visited);
            }
            ExtendedVerifier.visitDeprecation(node, visited);
            this.visitOverride(node, visited);
        }
        this.processDuplicateAnnotationContainers(node, nonSourceAnnotations);
    }

    private boolean shouldSkip(AnnotatedNode node, AnnotationNode visited) {
        return node instanceof ClassNode && !visited.isTargetAllowed(65) && !visited.isTargetAllowed(512) && visited.isTargetAllowed(2) || node instanceof ConstructorNode && !visited.isTargetAllowed(2) && visited.isTargetAllowed(65) || node instanceof FieldNode && !visited.isTargetAllowed(8) && !visited.isTargetAllowed(512) || node instanceof Parameter && !visited.isTargetAllowed(16) && !visited.isTargetAllowed(512) || node instanceof MethodNode && !(node instanceof ConstructorNode) && !visited.isTargetAllowed(4) && !visited.isTargetAllowed(512) || node instanceof RecordComponentNode && !visited.isTargetAllowed(1024) && !visited.isTargetAllowed(512);
    }

    private boolean isRepeatable(AnnotationNode annoNode) {
        ClassNode annoClassNode = annoNode.getClassNode();
        String name = annoClassNode.getName();
        if (!this.repeatableCache.containsKey(name)) {
            boolean result = false;
            for (AnnotationNode anno : annoClassNode.getAnnotations()) {
                if (!"java.lang.annotation.Repeatable".equals(anno.getClassNode().getName())) continue;
                result = true;
                break;
            }
            this.repeatableCache.put(name, result);
        }
        return this.repeatableCache.get(name);
    }

    private boolean isTypeUseScenario(AnnotationNode visited, int target) {
        return visited.isTargetAllowed(512) && (target & 0x80) == 0;
    }

    private void processDuplicateAnnotationContainers(AnnotatedNode node, Map<String, List<AnnotationNode>> nonSourceAnnotations) {
        for (Map.Entry<String, List<AnnotationNode>> entry : nonSourceAnnotations.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            ClassNode repeatable = null;
            AnnotationNode repeatee = entry.getValue().get(0);
            for (AnnotationNode anno : repeatee.getClassNode().getAnnotations()) {
                Expression value;
                if (!"java.lang.annotation.Repeatable".equals(anno.getClassNode().getName()) || !((value = anno.getMember("value")) instanceof ClassExpression) || !value.getType().isAnnotationDefinition()) continue;
                repeatable = value.getType();
                break;
            }
            if (repeatable == null) continue;
            if (nonSourceAnnotations.containsKey(repeatable.getName())) {
                this.addError("Cannot specify duplicate annotation on the same member. Explicit " + repeatable.getName() + " found when creating implicit container for " + entry.getKey(), node);
            }
            AnnotationNode collector = new AnnotationNode(repeatable);
            if (repeatee.hasClassRetention()) {
                collector.setClassRetention(true);
            } else if (repeatee.hasRuntimeRetention()) {
                collector.setRuntimeRetention(true);
            } else {
                List<AnnotationNode> retention = repeatable.getAnnotations(ClassHelper.makeCached(Retention.class));
                if (!retention.isEmpty()) {
                    Expression value = retention.get(0).getMember("value");
                    Object policy = value instanceof PropertyExpression ? ((PropertyExpression)value).getPropertyAsString() : StaticTypeCheckingSupport.evaluateExpression(value, this.source.getConfiguration(), this.source.getClassLoader());
                    if ("CLASS".equals(policy)) {
                        collector.setClassRetention(true);
                    } else if ("RUNTIME".equals(policy)) {
                        collector.setRuntimeRetention(true);
                    }
                }
            }
            collector.addMember("value", GeneralUtils.listX(entry.getValue().stream().map(AnnotationConstantExpression::new).collect(Collectors.toList())));
            node.getAnnotations().removeAll((Collection)entry.getValue());
            node.addAnnotation(collector);
        }
    }

    private static void visitDeprecation(AnnotatedNode node, AnnotationNode visited) {
        if (visited.getClassNode().isResolved() && visited.getClassNode().equals(ClassHelper.DEPRECATED_TYPE)) {
            if (node instanceof MethodNode) {
                MethodNode mn = (MethodNode)node;
                mn.setModifiers(mn.getModifiers() | 0x20000);
            } else if (node instanceof FieldNode) {
                FieldNode fn = (FieldNode)node;
                fn.setModifiers(fn.getModifiers() | 0x20000);
            } else if (node instanceof ClassNode) {
                ClassNode cn = (ClassNode)node;
                cn.setModifiers(cn.getModifiers() | 0x20000);
            }
        }
    }

    private void visitOverride(AnnotatedNode node, AnnotationNode visited) {
        ClassNode annotationType = visited.getClassNode();
        if (annotationType.isResolved() && "java.lang.Override".equals(annotationType.getName()) && node instanceof MethodNode && !Boolean.TRUE.equals(node.getNodeMetaData("DEFAULT_PARAMETER_GENERATED"))) {
            boolean override = false;
            MethodNode mNode = (MethodNode)node;
            ClassNode cNode = mNode.getDeclaringClass();
            if (mNode.hasDefaultValue()) {
                List<MethodNode> variants = cNode.getDeclaredMethods(mNode.getName());
                for (MethodNode m : variants) {
                    if (!m.getAnnotations().contains(visited) || !ExtendedVerifier.isOverrideMethod(m)) continue;
                    override = true;
                    break;
                }
            } else {
                override = ExtendedVerifier.isOverrideMethod(mNode);
            }
            if (!override) {
                this.addError("Method '" + mNode.getName() + "' from class '" + cNode.getName() + "' does not override method from its superclass or interfaces but is annotated with @Override.", visited);
            }
        }
    }

    private static boolean isOverrideMethod(MethodNode method) {
        ClassNode declaringClass = method.getDeclaringClass();
        LinkedList<ClassNode> todo = new LinkedList<ClassNode>();
        HashSet<ClassNode> done = new HashSet<ClassNode>();
        ClassNode next = declaringClass;
        do {
            if (!done.add(next)) continue;
            if (next != declaringClass && ExtendedVerifier.getDeclaredMethodCorrected(method, next) != null) {
                return true;
            }
            ClassNode sc = next.redirect().getUnresolvedSuperClass(false);
            if (sc != null) {
                todo.addFirst(GenericsUtils.parameterizeType(next, sc));
            }
            for (ClassNode in : next.getInterfaces()) {
                todo.add(GenericsUtils.parameterizeType(next, in));
            }
        } while ((next = (ClassNode)todo.poll()) != null);
        return false;
    }

    private static MethodNode getDeclaredMethodCorrected(MethodNode mn, ClassNode cn) {
        Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(cn);
        for (MethodNode declared : cn.getDeclaredMethods(mn.getName())) {
            MethodNode corrected = GenericsUtils.correctToGenericsSpec(genericsSpec, declared);
            if (!ParameterUtils.parametersEqual(corrected.getParameters(), mn.getParameters())) continue;
            return corrected;
        }
        return null;
    }
}

