/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.event.helix;

import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.util.ConfigStringUtil;
import org.apache.helix.util.InstanceValidationUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HelixEventHandlingUtil {
    private static Logger LOG = LoggerFactory.getLogger(HelixEventHandlingUtil.class);

    HelixEventHandlingUtil() {
    }

    static boolean isInstanceDisabledForCloudEvent(String instanceName, HelixDataAccessor dataAccessor) {
        InstanceConfig instanceConfig = (InstanceConfig)dataAccessor.getProperty(dataAccessor.keyBuilder().instanceConfig(instanceName));
        if (instanceConfig == null) {
            throw new HelixException("Instance: " + instanceName + ", instance config does not exist");
        }
        return !InstanceValidationUtil.isEnabled(dataAccessor, instanceName) && instanceConfig.getInstanceDisabledType().equals(InstanceConstants.InstanceDisabledType.CLOUD_EVENT.name());
    }

    static void updateCloudEventOperationInClusterConfig(final String clusterName, final String instanceName, BaseDataAccessor baseAccessor, final boolean enable, final String message) {
        String path = PropertyPathBuilder.clusterConfig(clusterName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster " + clusterName + ": cluster config does not exist");
        }
        if (!baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ": cluster config is null");
                }
                ClusterConfig clusterConfig = new ClusterConfig(currentData);
                TreeMap<String, String> disabledInstancesWithInfo = new TreeMap<String, String>(clusterConfig.getDisabledInstancesWithInfo());
                if (enable) {
                    disabledInstancesWithInfo.keySet().remove(instanceName);
                } else {
                    String timeStamp = String.valueOf(System.currentTimeMillis());
                    disabledInstancesWithInfo.put(instanceName, ZKHelixAdmin.assembleInstanceBatchedDisabledInfo(InstanceConstants.InstanceDisabledType.CLOUD_EVENT, message, timeStamp));
                }
                clusterConfig.setDisabledInstancesWithInfo(disabledInstancesWithInfo);
                return clusterConfig.getRecord();
            }
        }, AccessOption.PERSISTENT)) {
            LOG.error("Failed to update cluster config {} for {} instance {}. {}", new Object[]{clusterName, enable ? "enable" : "disable", instanceName, message});
        }
    }

    static boolean checkNoInstanceUnderCloudEvent(ClusterConfig clusterConfig) {
        Map<String, String> clusterConfigTrackedEvent = clusterConfig.getDisabledInstancesWithInfo();
        if (clusterConfigTrackedEvent == null || clusterConfigTrackedEvent.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : clusterConfigTrackedEvent.entrySet()) {
            if (!ConfigStringUtil.parseConcatenatedConfig(entry.getValue()).get(ClusterConfig.ClusterConfigProperty.HELIX_DISABLED_TYPE.toString()).equals(InstanceConstants.InstanceDisabledType.CLOUD_EVENT.name())) continue;
            return false;
        }
        return true;
    }
}

