/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.constraint.dataprovider;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.api.rebalancer.constraint.dataprovider.CapacityProvider;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class ZkBasedCapacityProvider
implements CapacityProvider {
    public static final int DEFAULT_CAPACITY_VALUE = 0;
    private static final String ROOT = "/PARTICIPANT_CAPACITY";
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private final String _dimensionPath;
    private ParticipantCapacity _capacity;

    public ZkBasedCapacityProvider(ZkHelixPropertyStore<ZNRecord> propertyStore, String dimensionName) {
        this._propertyStore = propertyStore;
        this._dimensionPath = "/PARTICIPANT_CAPACITY/" + dimensionName;
        ZNRecord existingRecord = (ZNRecord)this._propertyStore.get(this._dimensionPath, null, AccessOption.PERSISTENT);
        this._capacity = existingRecord == null ? new ParticipantCapacity(dimensionName) : new ParticipantCapacity(existingRecord);
    }

    public ZkBasedCapacityProvider(String zkAddr, String clusterName, String dimensionName) {
        this(new ZkHelixPropertyStore<ZNRecord>(zkAddr, new ZNRecordSerializer(), PropertyPathBuilder.propertyStore(clusterName)), dimensionName);
    }

    public void updateCapacity(Map<String, Integer> capacityMap, Map<String, Integer> usageMap, int defaultCapacity) {
        for (String participant : capacityMap.keySet()) {
            this._capacity.setCapacity(participant, capacityMap.get(participant));
        }
        for (String participant : usageMap.keySet()) {
            this._capacity.setUsage(participant, usageMap.get(participant));
        }
        this._capacity.setDefaultCapacity(defaultCapacity);
    }

    public boolean persistCapacity() {
        if (this._capacity.isValid()) {
            return this._propertyStore.set(this._dimensionPath, this._capacity.getRecord(), AccessOption.PERSISTENT);
        }
        throw new HelixException("Invalid ParticipantCapacity: " + this._capacity.getRecord().toString());
    }

    @Override
    public int getParticipantCapacity(String participant) {
        return this._capacity.getCapacity(participant);
    }

    @Override
    public int getParticipantUsage(String participant) {
        return this._capacity.getUsage(participant);
    }

    private static class ParticipantCapacity
    extends HelixProperty {
        private static final String CAPACITY = "CAPACITY";
        private static final String USAGE = "USAGE_SIZE";

        ParticipantCapacity(String dimensionName) {
            super(dimensionName);
            this._record.setIntField(ParticipantCapacityProperty.DEFAULT_CAPACITY.name(), 0);
        }

        ParticipantCapacity(ZNRecord record) {
            super(record);
            if (!this.isValid()) {
                throw new HelixException("Invalid ParticipantCapacity: " + record.toString());
            }
        }

        int getCapacity(String participant) {
            Map<String, String> participantMap = this._record.getMapField(participant);
            if (participantMap != null && participantMap.containsKey(CAPACITY)) {
                return Integer.parseInt(participantMap.get(CAPACITY));
            }
            return this.getDefaultCapacity();
        }

        int getUsage(String participant) {
            Map<String, String> participantMap = this._record.getMapField(participant);
            if (participantMap != null && participantMap.containsKey(USAGE)) {
                return Integer.parseInt(participantMap.get(USAGE));
            }
            return 0;
        }

        void setCapacity(String participant, int capacity) {
            Map<String, String> participantMap = this.getOrAddParticipantMap(participant);
            participantMap.put(CAPACITY, new Integer(capacity).toString());
        }

        void setUsage(String participant, int usage) {
            Map<String, String> participantMap = this.getOrAddParticipantMap(participant);
            participantMap.put(USAGE, new Integer(usage).toString());
        }

        private Map<String, String> getOrAddParticipantMap(String participant) {
            Map<String, String> participantMap = this._record.getMapField(participant);
            if (participantMap == null) {
                participantMap = new HashMap<String, String>();
                this._record.setMapField(participant, participantMap);
            }
            return participantMap;
        }

        void setDefaultCapacity(int defaultCapacity) {
            this._record.setIntField(ParticipantCapacityProperty.DEFAULT_CAPACITY.name(), defaultCapacity);
        }

        private int getDefaultCapacity() {
            return this._record.getIntField(ParticipantCapacityProperty.DEFAULT_CAPACITY.name(), 0);
        }

        @Override
        public boolean isValid() {
            try {
                int defaultCapacity = this.getDefaultCapacity();
                if (defaultCapacity < 0) {
                    return false;
                }
                for (Map<String, String> capacityRecords : this._record.getMapFields().values()) {
                    if ((!capacityRecords.containsKey(CAPACITY) || Integer.parseInt(capacityRecords.get(CAPACITY)) >= 0) && (!capacityRecords.containsKey(USAGE) || Integer.parseInt(capacityRecords.get(USAGE)) >= 0)) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        static enum ParticipantCapacityProperty {
            DEFAULT_CAPACITY;

        }
    }
}

