/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.changedetector.ResourceChangeDetector;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.DelayedAutoRebalancer;
import org.apache.helix.controller.rebalancer.StatefulRebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.DelayedRebalanceUtil;
import org.apache.helix.controller.rebalancer.util.WagedRebalanceUtil;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.AssignmentManager;
import org.apache.helix.controller.rebalancer.waged.AssignmentMetadataStore;
import org.apache.helix.controller.rebalancer.waged.GlobalRebalanceRunner;
import org.apache.helix.controller.rebalancer.waged.PartialRebalanceRunner;
import org.apache.helix.controller.rebalancer.waged.RebalanceAlgorithm;
import org.apache.helix.controller.rebalancer.waged.constraints.ConstraintBasedAlgorithmFactory;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModelProvider;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.monitoring.metrics.MetricCollector;
import org.apache.helix.monitoring.metrics.WagedRebalancerMetricCollector;
import org.apache.helix.monitoring.metrics.model.CountMetric;
import org.apache.helix.monitoring.metrics.model.LatencyMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WagedRebalancer
implements StatefulRebalancer<ResourceControllerDataProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(WagedRebalancer.class);
    private static final Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> NOT_CONFIGURED_PREFERENCE = ImmutableMap.of((Object)((Object)ClusterConfig.GlobalRebalancePreferenceKey.EVENNESS), (Object)-1, (Object)((Object)ClusterConfig.GlobalRebalancePreferenceKey.LESS_MOVEMENT), (Object)-1);
    private static final RebalanceAlgorithm DEFAULT_REBALANCE_ALGORITHM = ConstraintBasedAlgorithmFactory.getInstance(ClusterConfig.DEFAULT_GLOBAL_REBALANCE_PREFERENCE);
    private static final List<HelixRebalanceException.Type> FAILURE_TYPES_TO_PROPAGATE = List.of(HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, HelixRebalanceException.Type.UNKNOWN_FAILURE);
    private final HelixManager _manager;
    private final MappingCalculator<ResourceControllerDataProvider> _mappingCalculator;
    private final AssignmentMetadataStore _assignmentMetadataStore;
    private final MetricCollector _metricCollector;
    private final CountMetric _rebalanceFailureCount;
    private final LatencyMetric _writeLatency;
    private final CountMetric _emergencyRebalanceCounter;
    private final LatencyMetric _emergencyRebalanceLatency;
    private final CountMetric _rebalanceOverwriteCounter;
    private final LatencyMetric _rebalanceOverwriteLatency;
    private final AssignmentManager _assignmentManager;
    private final PartialRebalanceRunner _partialRebalanceRunner;
    private final GlobalRebalanceRunner _globalRebalanceRunner;
    private RebalanceAlgorithm _rebalanceAlgorithm;
    private Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> _preference = NOT_CONFIGURED_PREFERENCE;

    private static AssignmentMetadataStore constructAssignmentStore(String metadataStoreAddrs, String clusterName) {
        if (metadataStoreAddrs != null && clusterName != null) {
            return new AssignmentMetadataStore(metadataStoreAddrs, clusterName);
        }
        return null;
    }

    public WagedRebalancer(HelixManager helixManager) {
        this(helixManager == null ? null : WagedRebalancer.constructAssignmentStore(helixManager.getMetadataStoreConnectionString(), helixManager.getClusterName()), DEFAULT_REBALANCE_ALGORITHM, new DelayedAutoRebalancer(), helixManager, helixManager == null ? new WagedRebalancerMetricCollector() : new WagedRebalancerMetricCollector(helixManager.getClusterName()), true, true);
        this._preference = ImmutableMap.copyOf(ClusterConfig.DEFAULT_GLOBAL_REBALANCE_PREFERENCE);
    }

    protected WagedRebalancer(AssignmentMetadataStore assignmentMetadataStore, RebalanceAlgorithm algorithm, Optional<MetricCollector> metricCollectorOptional) {
        this(assignmentMetadataStore, algorithm, new DelayedAutoRebalancer(), null, metricCollectorOptional.orElse(new WagedRebalancerMetricCollector()), false, false);
    }

    private WagedRebalancer(AssignmentMetadataStore assignmentMetadataStore, RebalanceAlgorithm algorithm, MappingCalculator mappingCalculator, HelixManager manager, MetricCollector metricCollector, boolean isAsyncGlobalRebalanceEnabled, boolean isAsyncPartialRebalanceEnabled) {
        if (assignmentMetadataStore == null) {
            LOG.warn("Assignment Metadata Store is not configured properly. The rebalancer will not access the assignment store during the rebalance.");
        }
        this._assignmentMetadataStore = assignmentMetadataStore;
        this._rebalanceAlgorithm = algorithm;
        this._mappingCalculator = mappingCalculator;
        if (manager == null) {
            LOG.warn("HelixManager is not provided. The rebalancer is not going to schedule for a future rebalance even when delayed rebalance is enabled.");
        }
        this._manager = manager;
        this._metricCollector = metricCollector;
        this._rebalanceFailureCount = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.RebalanceFailureCounter.name(), CountMetric.class);
        this._emergencyRebalanceCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.EmergencyRebalanceCounter.name(), CountMetric.class);
        this._emergencyRebalanceLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.EmergencyRebalanceLatencyGauge.name(), LatencyMetric.class);
        this._rebalanceOverwriteCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.RebalanceOverwriteCounter.name(), CountMetric.class);
        this._rebalanceOverwriteLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.RebalanceOverwriteLatencyGauge.name(), LatencyMetric.class);
        this._writeLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.StateWriteLatencyGauge.name(), LatencyMetric.class);
        this._assignmentManager = new AssignmentManager(this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.StateReadLatencyGauge.name(), LatencyMetric.class));
        this._partialRebalanceRunner = new PartialRebalanceRunner(this._assignmentManager, assignmentMetadataStore, metricCollector, this._rebalanceFailureCount, isAsyncPartialRebalanceEnabled);
        this._globalRebalanceRunner = new GlobalRebalanceRunner(this._assignmentManager, assignmentMetadataStore, metricCollector, this._writeLatency, this._rebalanceFailureCount, isAsyncGlobalRebalanceEnabled);
    }

    public void setGlobalRebalanceAsyncMode(boolean isAsyncGlobalRebalanceEnabled) {
        this._globalRebalanceRunner.setGlobalRebalanceAsyncMode(isAsyncGlobalRebalanceEnabled);
    }

    public void setPartialRebalanceAsyncMode(boolean isAsyncPartialRebalanceEnabled) {
        this._partialRebalanceRunner.setPartialRebalanceAsyncMode(isAsyncPartialRebalanceEnabled);
    }

    public synchronized void updateRebalancePreference(Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> newPreference) {
        if (!this._preference.equals(NOT_CONFIGURED_PREFERENCE) && !this._preference.equals(newPreference)) {
            this._rebalanceAlgorithm = ConstraintBasedAlgorithmFactory.getInstance(newPreference);
            this._preference = ImmutableMap.copyOf(newPreference);
        }
    }

    @Override
    public void reset() {
        if (this._assignmentMetadataStore != null) {
            this._assignmentMetadataStore.reset();
        }
        this._globalRebalanceRunner.resetChangeDetector();
    }

    @Override
    public void close() {
        this._partialRebalanceRunner.close();
        this._globalRebalanceRunner.close();
        if (this._assignmentMetadataStore != null) {
            this._assignmentMetadataStore.close();
        }
        this._metricCollector.unregister();
    }

    @Override
    public Map<String, IdealState> computeNewIdealStates(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) throws HelixRebalanceException {
        Map<String, IdealState> newIdealStates;
        LOG.info("Start computing new ideal states for resources: {}", (Object)resourceMap.keySet().toString());
        this.validateInput(clusterData, resourceMap);
        try {
            newIdealStates = this.computeBestPossibleStates(clusterData, resourceMap, currentStateOutput, this._rebalanceAlgorithm);
        }
        catch (HelixRebalanceException ex) {
            LOG.error("Failed to calculate the new assignments.", (Throwable)ex);
            this._rebalanceFailureCount.increment(1L);
            HelixRebalanceException.Type failureType = ex.getFailureType();
            if (this.failureTypesToPropagate().contains((Object)failureType)) {
                throw ex;
            }
            LOG.warn("Returning the last known-good best possible assignment from metadata store due to rebalance failure of type: {}", (Object)failureType);
            Map<String, ResourceAssignment> assignmentRecord = this._assignmentManager.getBestPossibleAssignment(this._assignmentMetadataStore, new CurrentStateOutput(), resourceMap.keySet());
            newIdealStates = this.convertResourceAssignment(clusterData, assignmentRecord);
        }
        newIdealStates.values().parallelStream().forEach(idealState -> {
            String resourceName = idealState.getResourceName();
            ResourceAssignment finalAssignment = this._mappingCalculator.computeBestPossiblePartitionState(clusterData, (IdealState)idealState, (Resource)resourceMap.get(resourceName), currentStateOutput);
            idealState.getRecord().getMapFields().clear();
            for (Partition partition : finalAssignment.getMappedPartitions()) {
                Map<String, String> newStateMap = finalAssignment.getReplicaMap(partition);
                idealState.setInstanceStateMap(partition.getPartitionName(), newStateMap == null ? Collections.emptyMap() : newStateMap);
            }
        });
        LOG.info("Finish computing new ideal states for resources: {}", (Object)resourceMap.keySet().toString());
        return newIdealStates;
    }

    private Map<String, IdealState> computeBestPossibleStates(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        Set<String> activeNodes = DelayedRebalanceUtil.getActiveNodes(clusterData.getAllInstances(), clusterData.getEnabledLiveInstances(), clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), clusterData.getClusterConfig());
        this.delayedRebalanceSchedule(clusterData, activeNodes, resourceMap.keySet());
        Map<String, ResourceAssignment> newBestPossibleAssignment = this.computeBestPossibleAssignment(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm);
        Map<String, IdealState> newIdealStates = this.convertResourceAssignment(clusterData, newBestPossibleAssignment);
        newIdealStates.forEach((resourceName, idealState) -> this.applyUserDefinedPreferenceList(clusterData.getResourceConfig((String)resourceName), (IdealState)idealState));
        return newIdealStates;
    }

    protected Map<String, ResourceAssignment> computeBestPossibleAssignment(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        this._globalRebalanceRunner.globalRebalance(clusterData, resourceMap, currentStateOutput, algorithm);
        return this.emergencyRebalance(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm);
    }

    private Map<String, IdealState> convertResourceAssignment(ResourceControllerDataProvider clusterData, Map<String, ResourceAssignment> assignments) throws HelixRebalanceException {
        HashMap<String, IdealState> finalIdealStateMap = new HashMap<String, IdealState>();
        for (String resourceName : assignments.keySet()) {
            try {
                IdealState currentIdealState = clusterData.getIdealState(resourceName);
                Map<String, Integer> statePriorityMap = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef()).getStatePriorityMap();
                IdealState newIdealState = new IdealState(resourceName);
                newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
                newIdealState.setPreferenceLists(this.getPreferenceLists(assignments.get(resourceName), statePriorityMap));
                finalIdealStateMap.put(resourceName, newIdealState);
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to calculate the new IdealState for resource: " + resourceName, HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
            }
        }
        return finalIdealStateMap;
    }

    protected List<HelixRebalanceException.Type> failureTypesToPropagate() {
        return FAILURE_TYPES_TO_PROPAGATE;
    }

    private Map<String, ResourceAssignment> handleDelayedRebalanceMinActiveReplica(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, Map<String, ResourceAssignment> currentResourceAssignment, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        Set<String> enabledLiveInstances = WagedRebalancer.filterOutOnOperationInstances(clusterData.getInstanceConfigMap(), clusterData.getEnabledLiveInstances());
        if (activeNodes.equals(enabledLiveInstances) || !this.requireRebalanceOverwrite(clusterData, currentResourceAssignment)) {
            return currentResourceAssignment;
        }
        this._rebalanceOverwriteCounter.increment(1L);
        this._rebalanceOverwriteLatency.startMeasuringLatency();
        LOG.info("Start delayed rebalance overwrites in emergency rebalance.");
        try {
            ClusterModel clusterModel = ClusterModelProvider.generateClusterModelForDelayedRebalanceOverwrites(clusterData, resourceMap, enabledLiveInstances, currentResourceAssignment);
            Map<String, ResourceAssignment> assignment = WagedRebalanceUtil.calculateAssignment(clusterModel, algorithm);
            assignment.keySet().retainAll(clusterModel.getAssignableReplicaMap().keySet());
            DelayedRebalanceUtil.mergeAssignments(assignment, currentResourceAssignment);
            Map<String, ResourceAssignment> map = currentResourceAssignment;
            return map;
        }
        catch (HelixRebalanceException e) {
            LOG.error("Failed to compute for delayed rebalance overwrites in cluster {}", (Object)clusterData.getClusterName());
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to compute for delayed rebalance overwrites in cluster {}", (Object)clusterData.getClusterName());
            throw new HelixRebalanceException("Failed to compute for delayed rebalance overwrites in cluster " + clusterData.getClusterConfig(), HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, e);
        }
        finally {
            this._rebalanceOverwriteLatency.endMeasuringLatency();
        }
    }

    private static Set<String> filterOutOnOperationInstances(Map<String, InstanceConfig> instanceConfigMap, Set<String> nodes) {
        return nodes.stream().filter(instance -> !DelayedAutoRebalancer.INSTANCE_OPERATION_TO_EXCLUDE_FROM_ASSIGNMENT.contains(((InstanceConfig)instanceConfigMap.get(instance)).getInstanceOperation())).collect(Collectors.toSet());
    }

    protected Map<String, ResourceAssignment> emergencyRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        Map<String, ResourceAssignment> newAssignment;
        LOG.info("Start emergency rebalance.");
        this._emergencyRebalanceCounter.increment(1L);
        this._emergencyRebalanceLatency.startMeasuringLatency();
        Map<String, ResourceAssignment> currentBestPossibleAssignment = this._assignmentManager.getBestPossibleAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        AtomicBoolean allNodesActive = new AtomicBoolean(true);
        currentBestPossibleAssignment.values().parallelStream().forEach(resourceAssignment -> resourceAssignment.getMappedPartitions().parallelStream().forEach(partition -> {
            for (String instance : resourceAssignment.getReplicaMap((Partition)partition).keySet()) {
                if (activeNodes.contains(instance)) continue;
                allNodesActive.set(false);
                break;
            }
        }));
        if (!allNodesActive.get()) {
            ClusterModel clusterModel;
            LOG.info("Emergency rebalance responding to permanent node down.");
            try {
                clusterModel = ClusterModelProvider.generateClusterModelForEmergencyRebalance(clusterData, resourceMap, activeNodes, currentBestPossibleAssignment);
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to generate cluster model for emergency rebalance.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
            }
            newAssignment = WagedRebalanceUtil.calculateAssignment(clusterModel, algorithm);
        } else {
            newAssignment = currentBestPossibleAssignment;
        }
        this.persistBestPossibleAssignment(newAssignment);
        Map<String, ResourceAssignment> assignmentWithDelayedRebalanceAdjust = newAssignment;
        if (this._partialRebalanceRunner.isAsyncPartialRebalanceEnabled()) {
            assignmentWithDelayedRebalanceAdjust = this.handleDelayedRebalanceMinActiveReplica(clusterData, resourceMap, activeNodes, newAssignment, algorithm);
        }
        this._emergencyRebalanceLatency.endMeasuringLatency();
        LOG.info("Finish emergency rebalance");
        this._partialRebalanceRunner.partialRebalance(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm);
        if (!this._partialRebalanceRunner.isAsyncPartialRebalanceEnabled()) {
            newAssignment = this._assignmentManager.getBestPossibleAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
            this.persistBestPossibleAssignment(newAssignment);
            assignmentWithDelayedRebalanceAdjust = this.handleDelayedRebalanceMinActiveReplica(clusterData, resourceMap, activeNodes, newAssignment, algorithm);
        }
        return assignmentWithDelayedRebalanceAdjust;
    }

    private Map<String, List<String>> getPreferenceLists(ResourceAssignment newAssignment, Map<String, Integer> statePriorityMap) {
        HashMap<String, List<String>> preferenceList = new HashMap<String, List<String>>();
        for (Partition partition : newAssignment.getMappedPartitions()) {
            ArrayList<String> nodes = new ArrayList<String>(newAssignment.getReplicaMap(partition).keySet());
            nodes.sort((node1, node2) -> {
                int statePriority2;
                int statePriority1 = (Integer)statePriorityMap.get(newAssignment.getReplicaMap(partition).get(node1));
                if (statePriority1 == (statePriority2 = ((Integer)statePriorityMap.get(newAssignment.getReplicaMap(partition).get(node2))).intValue())) {
                    return node1.compareTo((String)node2);
                }
                return statePriority1 - statePriority2;
            });
            preferenceList.put(partition.getPartitionName(), nodes);
        }
        return preferenceList;
    }

    private void validateInput(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap) throws HelixRebalanceException {
        Set nonCompatibleResources = resourceMap.keySet().stream().filter(resource -> !WagedValidationUtil.isWagedEnabled(clusterData.getIdealState((String)resource))).collect(Collectors.toSet());
        if (!nonCompatibleResources.isEmpty()) {
            throw new HelixRebalanceException(String.format("Input contains invalid resource(s) that cannot be rebalanced by the WAGED rebalancer. %s", nonCompatibleResources.toString()), HelixRebalanceException.Type.INVALID_INPUT);
        }
    }

    protected Map<String, ResourceAssignment> getBestPossibleAssignment(AssignmentMetadataStore assignmentMetadataStore, CurrentStateOutput currentStateOutput, Set<String> resources) throws HelixRebalanceException {
        return this._assignmentManager.getBestPossibleAssignment(assignmentMetadataStore, currentStateOutput, resources);
    }

    private void persistBestPossibleAssignment(Map<String, ResourceAssignment> bestPossibleAssignment) throws HelixRebalanceException {
        if (this._assignmentMetadataStore != null && this._assignmentMetadataStore.isBestPossibleChanged(bestPossibleAssignment)) {
            try {
                this._writeLatency.startMeasuringLatency();
                this._assignmentMetadataStore.persistBestPossibleAssignment(bestPossibleAssignment);
                this._writeLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to persist the new best possible assignment.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip persisting the best possible assignment.");
        }
    }

    private void delayedRebalanceSchedule(ResourceControllerDataProvider clusterData, Set<String> delayedActiveNodes, Set<String> resourceSet) {
        if (this._manager != null) {
            ClusterConfig clusterConfig = clusterData.getClusterConfig();
            boolean delayedRebalanceEnabled = DelayedRebalanceUtil.isDelayRebalanceEnabled(clusterConfig);
            HashSet<String> offlineOrDisabledInstances = new HashSet<String>(delayedActiveNodes);
            offlineOrDisabledInstances.removeAll(clusterData.getEnabledLiveInstances());
            for (String resource : resourceSet) {
                DelayedRebalanceUtil.setRebalanceScheduler(resource, delayedRebalanceEnabled, offlineOrDisabledInstances, clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), clusterConfig.getRebalanceDelayTime(), clusterConfig, this._manager);
            }
        } else {
            LOG.warn("Skip scheduling a delayed rebalancer since HelixManager is not specified.");
        }
    }

    protected boolean requireRebalanceOverwrite(ResourceControllerDataProvider clusterData, Map<String, ResourceAssignment> bestPossibleAssignment) {
        AtomicBoolean allMinActiveReplicaMet = new AtomicBoolean(true);
        bestPossibleAssignment.values().parallelStream().forEach(resourceAssignment -> {
            String resourceName = resourceAssignment.getResourceName();
            IdealState currentIdealState = clusterData.getIdealState(resourceName);
            Set<String> enabledLiveInstances = WagedRebalancer.filterOutOnOperationInstances(clusterData.getInstanceConfigMap(), clusterData.getEnabledLiveInstances());
            int numReplica = currentIdealState.getReplicaCount(enabledLiveInstances.size());
            int minActiveReplica = DelayedRebalanceUtil.getMinActiveReplica(ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), currentIdealState), currentIdealState, numReplica);
            resourceAssignment.getMappedPartitions().parallelStream().forEach(partition -> {
                int enabledLivePlacementCounter = 0;
                for (String instance : resourceAssignment.getReplicaMap((Partition)partition).keySet()) {
                    if (!enabledLiveInstances.contains(instance)) continue;
                    ++enabledLivePlacementCounter;
                }
                if (enabledLivePlacementCounter < Math.min(minActiveReplica, numReplica)) {
                    allMinActiveReplicaMet.set(false);
                }
            });
        });
        return !allMinActiveReplicaMet.get();
    }

    private void applyUserDefinedPreferenceList(ResourceConfig resourceConfig, IdealState idealState) {
        Map<String, List<String>> userDefinedPreferenceList;
        if (resourceConfig != null && !(userDefinedPreferenceList = resourceConfig.getPreferenceLists()).isEmpty()) {
            LOG.info("Using user defined preference list for partitions.");
            for (String partition : userDefinedPreferenceList.keySet()) {
                idealState.setPreferenceList(partition, userDefinedPreferenceList.get(partition));
            }
        }
    }

    protected AssignmentMetadataStore getAssignmentMetadataStore() {
        return this._assignmentMetadataStore;
    }

    protected MetricCollector getMetricCollector() {
        return this._metricCollector;
    }

    protected ResourceChangeDetector getChangeDetector() {
        return this._globalRebalanceRunner.getChangeDetector();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

