/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.model;

import java.util.Map;
import org.apache.helix.controller.rebalancer.util.WagedRebalanceUtil;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignableReplica
implements Comparable<AssignableReplica> {
    private static final Logger LOG = LoggerFactory.getLogger(AssignableReplica.class);
    private final String _replicaKey;
    private final String _partitionName;
    private final String _resourceName;
    private final String _resourceInstanceGroupTag;
    private final int _resourceMaxPartitionsPerInstance;
    private final Map<String, Integer> _capacityUsage;
    private final int _statePriority;
    private final String _replicaState;

    public AssignableReplica(ClusterConfig clusterConfig, ResourceConfig resourceConfig, String partitionName, String replicaState, int statePriority) {
        this._partitionName = partitionName;
        this._replicaState = replicaState;
        this._statePriority = statePriority;
        this._resourceName = resourceConfig.getResourceName();
        this._capacityUsage = WagedRebalanceUtil.fetchCapacityUsage(partitionName, resourceConfig, clusterConfig);
        this._resourceInstanceGroupTag = resourceConfig.getInstanceGroupTag();
        this._resourceMaxPartitionsPerInstance = resourceConfig.getMaxPartitionsPerInstance();
        this._replicaKey = AssignableReplica.generateReplicaKey(this._resourceName, this._partitionName, this._replicaState);
    }

    public Map<String, Integer> getCapacity() {
        return this._capacityUsage;
    }

    public String getPartitionName() {
        return this._partitionName;
    }

    public String getReplicaState() {
        return this._replicaState;
    }

    public boolean isReplicaTopState() {
        return this._statePriority == 1;
    }

    public int getStatePriority() {
        return this._statePriority;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public String getResourceInstanceGroupTag() {
        return this._resourceInstanceGroupTag;
    }

    public boolean hasResourceInstanceGroupTag() {
        return this._resourceInstanceGroupTag != null && !this._resourceInstanceGroupTag.isEmpty();
    }

    public int getResourceMaxPartitionsPerInstance() {
        return this._resourceMaxPartitionsPerInstance;
    }

    public String toString() {
        return this._replicaKey;
    }

    @Override
    public int compareTo(AssignableReplica replica) {
        if (!this._resourceName.equals(replica._resourceName)) {
            return this._resourceName.compareTo(replica._resourceName);
        }
        if (!this._partitionName.equals(replica._partitionName)) {
            return this._partitionName.compareTo(replica._partitionName);
        }
        if (!this._replicaState.equals(replica._replicaState)) {
            return this._replicaState.compareTo(replica._replicaState);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AssignableReplica) {
            return this.compareTo((AssignableReplica)obj) == 0;
        }
        return false;
    }

    public static String generateReplicaKey(String resourceName, String partitionName, String state) {
        return String.format("%s-%s-%s", resourceName, partitionName, state);
    }
}

