/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.util.ConfigStringUtil;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceConfig
extends HelixProperty {
    public static final int WEIGHT_NOT_SET = -1;
    public static final int MAX_CONCURRENT_TASK_NOT_SET = -1;
    private static final int TARGET_TASK_THREAD_POOL_SIZE_NOT_SET = -1;
    private static final boolean HELIX_ENABLED_DEFAULT_VALUE = true;
    private static final long HELIX_ENABLED_TIMESTAMP_DEFAULT_VALUE = -1L;
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private static final ImmutableSet<InstanceConfigProperty> NON_OVERWRITABLE_PROPERTIES = ImmutableSet.of((Object)((Object)InstanceConfigProperty.HELIX_HOST), (Object)((Object)InstanceConfigProperty.HELIX_PORT), (Object)((Object)InstanceConfigProperty.HELIX_ZONE_ID), (Object)((Object)InstanceConfigProperty.DOMAIN), (Object)((Object)InstanceConfigProperty.INSTANCE_INFO_MAP));
    private static final Logger _logger = LoggerFactory.getLogger((String)InstanceConfig.class.getName());
    private List<InstanceOperation> _deserializedInstanceOperations;

    public InstanceConfig(String instanceId) {
        super(instanceId);
    }

    public InstanceConfig(ZNRecord record) {
        super(record);
    }

    public String getHostName() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_HOST.name());
    }

    public void setHostName(String hostName) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_HOST.name(), hostName);
    }

    public String getPort() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_PORT.name());
    }

    public void setPort(String port) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_PORT.name(), port);
    }

    @Deprecated
    public String getZoneId() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_ZONE_ID.name());
    }

    public void setZoneId(String zoneId) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_ZONE_ID.name(), zoneId);
    }

    @Deprecated
    public String getDomain() {
        return this._record.getSimpleField(InstanceConfigProperty.DOMAIN.name());
    }

    public String getDomainAsString() {
        return this._record.getSimpleField(InstanceConfigProperty.DOMAIN.name());
    }

    public Map<String, String> getDomainAsMap() {
        String domain = this.getDomainAsString();
        return ConfigStringUtil.parseConcatenatedConfig(this.getDomainAsString());
    }

    public void setDomain(String domain) {
        this._record.setSimpleField(InstanceConfigProperty.DOMAIN.name(), domain);
    }

    public void setDomain(Map<String, String> domainMap) {
        this.setDomain(ConfigStringUtil.concatenateMapping(domainMap));
    }

    public int getWeight() {
        String w = this._record.getSimpleField(InstanceConfigProperty.INSTANCE_WEIGHT.name());
        if (w != null) {
            try {
                int weight = Integer.valueOf(w);
                return weight;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setWeight(int weight) {
        if (weight <= 0) {
            throw new IllegalArgumentException("Instance weight can not be equal or less than 0!");
        }
        this._record.setSimpleField(InstanceConfigProperty.INSTANCE_WEIGHT.name(), String.valueOf(weight));
    }

    public List<String> getTags() {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.name());
        if (tags == null) {
            tags = new ArrayList<String>(0);
        }
        return tags;
    }

    public void addTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.name());
        if (tags == null) {
            tags = new ArrayList<String>(0);
        }
        if (!tags.contains(tag)) {
            tags.add(tag);
        }
        this.getRecord().setListField(InstanceConfigProperty.TAG_LIST.name(), tags);
    }

    public void removeTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.name());
        if (tags == null) {
            return;
        }
        if (tags.contains(tag)) {
            tags.remove(tag);
        }
    }

    public boolean containsTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.name());
        if (tags == null) {
            return false;
        }
        return tags.contains(tag);
    }

    public long getInstanceEnabledTime() {
        return this._record.getLongField(InstanceConfigProperty.HELIX_ENABLED_TIMESTAMP.name(), -1L);
    }

    @Deprecated
    public void setInstanceEnabled(boolean enabled) {
        this.setInstanceEnabledHelper(enabled, null);
    }

    private void setInstanceEnabledHelper(boolean enabled, Long timestampOverride) {
        this._record.setBooleanField(InstanceConfigProperty.HELIX_ENABLED.name(), enabled);
        this._record.setLongField(InstanceConfigProperty.HELIX_ENABLED_TIMESTAMP.name(), timestampOverride != null ? timestampOverride : System.currentTimeMillis());
        if (enabled) {
            this.resetInstanceDisabledTypeAndReason();
        }
    }

    @Deprecated
    public void resetInstanceDisabledTypeAndReason() {
        this._record.getSimpleFields().remove(InstanceConfigProperty.HELIX_DISABLED_REASON.name());
        this._record.getSimpleFields().remove(InstanceConfigProperty.HELIX_DISABLED_TYPE.name());
    }

    @Deprecated
    public void setInstanceDisabledReason(String disabledReason) {
        if (this.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.DISABLE)) {
            this._record.setSimpleField(InstanceConfigProperty.HELIX_DISABLED_REASON.name(), disabledReason);
        }
    }

    @Deprecated
    public void setInstanceDisabledType(InstanceConstants.InstanceDisabledType disabledType) {
        if (this.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.DISABLE)) {
            this._record.setSimpleField(InstanceConfigProperty.HELIX_DISABLED_TYPE.name(), disabledType.name());
        }
    }

    @Deprecated
    public String getInstanceDisabledReason() {
        return this._record.getStringField(InstanceConfigProperty.HELIX_DISABLED_REASON.name(), "");
    }

    @Deprecated
    public String getInstanceDisabledType() {
        if (this._record.getBooleanField(InstanceConfigProperty.HELIX_ENABLED.name(), true)) {
            return "INSTANCE_NOT_DISABLED";
        }
        return this._record.getStringField(InstanceConfigProperty.HELIX_DISABLED_TYPE.name(), InstanceConstants.InstanceDisabledType.DEFAULT_INSTANCE_DISABLE_TYPE.name());
    }

    private List<InstanceOperation> getInstanceOperations() {
        if (this._deserializedInstanceOperations == null || this._deserializedInstanceOperations.isEmpty()) {
            List<String> instanceOperations = this._record.getListField(InstanceConfigProperty.HELIX_INSTANCE_OPERATIONS.name());
            ArrayList<InstanceOperation> newDeserializedInstanceOperations = new ArrayList<InstanceOperation>();
            if (instanceOperations != null) {
                for (String serializedInstanceOperation : instanceOperations) {
                    try {
                        Map properties = (Map)_objectMapper.readValue(serializedInstanceOperation, (TypeReference)new TypeReference<Map<String, String>>(){});
                        newDeserializedInstanceOperations.add(new InstanceOperation(properties));
                    }
                    catch (JsonProcessingException e) {
                        _logger.error("Failed to deserialize instance operation for instance: " + this._record.getId(), (Throwable)e);
                    }
                }
            }
            this._deserializedInstanceOperations = newDeserializedInstanceOperations;
        }
        return this._deserializedInstanceOperations;
    }

    public void setInstanceOperation(InstanceOperation operation) {
        List<InstanceOperation> deserializedInstanceOperations = this.getInstanceOperations();
        if (operation.getSource() == InstanceConstants.InstanceOperationSource.ADMIN) {
            deserializedInstanceOperations.clear();
        } else {
            deserializedInstanceOperations.removeIf(instanceOperation -> instanceOperation.getSource() == operation.getSource());
        }
        if (operation.getOperation() == InstanceConstants.InstanceOperation.ENABLE) {
            int insertIndex = 0;
            for (int i = deserializedInstanceOperations.size() - 1; i >= 0; --i) {
                if (deserializedInstanceOperations.get(i).getOperation() != InstanceConstants.InstanceOperation.ENABLE) continue;
                insertIndex = i + 1;
                break;
            }
            deserializedInstanceOperations.add(insertIndex, operation);
        } else {
            deserializedInstanceOperations.add(operation);
        }
        this._record.setListField(InstanceConfigProperty.HELIX_INSTANCE_OPERATIONS.name(), deserializedInstanceOperations.stream().map(instanceOperation -> {
            try {
                return _objectMapper.writeValueAsString(instanceOperation.getProperties());
            }
            catch (JsonProcessingException e) {
                throw new HelixException("Failed to serialize instance operation for instance: " + this._record.getId() + " Can't set the instance operation to: " + operation.getOperation(), e);
            }
        }).collect(Collectors.toList()));
        if (operation.getOperation() == InstanceConstants.InstanceOperation.DISABLE) {
            if (this._record.getBooleanField(InstanceConfigProperty.HELIX_ENABLED.name(), true)) {
                this.setInstanceEnabledHelper(false, operation.getTimestamp());
            }
            this._record.setSimpleField(InstanceConfigProperty.HELIX_DISABLED_REASON.name(), operation.getReason());
            this._record.setSimpleField(InstanceConfigProperty.HELIX_DISABLED_TYPE.name(), InstanceConstants.InstanceDisabledType.DEFAULT_INSTANCE_DISABLE_TYPE.name());
        } else if (operation.getOperation() == InstanceConstants.InstanceOperation.ENABLE) {
            InstanceOperation latestDisableInstanceOperation = null;
            for (InstanceOperation instanceOperation2 : this.getInstanceOperations()) {
                if (instanceOperation2.getOperation() != InstanceConstants.InstanceOperation.DISABLE || latestDisableInstanceOperation != null && instanceOperation2.getTimestamp() <= latestDisableInstanceOperation.getTimestamp()) continue;
                latestDisableInstanceOperation = instanceOperation2;
            }
            if (latestDisableInstanceOperation != null) {
                this._record.setSimpleField(InstanceConfigProperty.HELIX_DISABLED_REASON.name(), latestDisableInstanceOperation.getReason());
                this._record.setSimpleField(InstanceConfigProperty.HELIX_DISABLED_TYPE.name(), InstanceConstants.InstanceDisabledType.DEFAULT_INSTANCE_DISABLE_TYPE.name());
            } else {
                this.setInstanceEnabledHelper(true, operation.getTimestamp());
            }
        }
    }

    public void setInstanceOperation(InstanceConstants.InstanceOperation operation) {
        InstanceOperation instanceOperation = new InstanceOperation.Builder().setOperation(operation).build();
        this.setInstanceOperation(instanceOperation);
    }

    private void setInstanceOperationInit(InstanceConstants.InstanceOperation operation) {
        if (operation == null) {
            return;
        }
        InstanceOperation instanceOperation = new InstanceOperation.Builder().setOperation(operation).setReason("INIT").build();
        instanceOperation.setTimestamp(-1L);
        this.setInstanceOperation(instanceOperation);
    }

    private InstanceOperation getActiveInstanceOperation() {
        List<InstanceOperation> instanceOperations = this.getInstanceOperations();
        if (instanceOperations.isEmpty()) {
            InstanceOperation instanceOperation = new InstanceOperation.Builder().setOperation(InstanceConstants.InstanceOperation.ENABLE).setSource(InstanceConstants.InstanceOperationSource.DEFAULT).build();
            instanceOperation.setTimestamp(-1L);
            return instanceOperation;
        }
        return instanceOperations.get(instanceOperations.size() - 1);
    }

    public InstanceOperation getInstanceOperation() {
        InstanceOperation activeInstanceOperation = this.getActiveInstanceOperation();
        try {
            activeInstanceOperation.getOperation();
        }
        catch (IllegalArgumentException e) {
            _logger.error("Invalid instance operation type for instance: " + this._record.getId() + ". You may need to update your version of Helix to get support for this type of InstanceOperation. Defaulting to UNKNOWN.");
            activeInstanceOperation = new InstanceOperation.Builder().setOperation(InstanceConstants.InstanceOperation.UNKNOWN).build();
        }
        if (!this._record.getBooleanField(InstanceConfigProperty.HELIX_ENABLED.name(), true) && InstanceConstants.INSTANCE_DISABLED_OVERRIDABLE_OPERATIONS.contains((Object)activeInstanceOperation.getOperation())) {
            return new InstanceOperation.Builder().setOperation(InstanceConstants.InstanceOperation.DISABLE).setReason(this.getInstanceDisabledReason()).setSource(InstanceConstants.InstanceOperationSource.instanceDisabledTypeToInstanceOperationSource(InstanceConstants.InstanceDisabledType.valueOf(this.getInstanceDisabledType()))).build();
        }
        return activeInstanceOperation;
    }

    public boolean getInstanceEnabled() {
        return this.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.ENABLE);
    }

    public boolean isAssignable() {
        return InstanceConstants.ASSIGNABLE_INSTANCE_OPERATIONS.contains((Object)this.getInstanceOperation().getOperation());
    }

    @Deprecated
    public boolean getInstanceEnabledForPartition(String partition) {
        boolean enabled = true;
        Map<String, String> disabledPartitionMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        for (String resourceName : disabledPartitionMap.keySet()) {
            enabled &= this.getInstanceEnabledForPartition(resourceName, partition);
        }
        return enabled;
    }

    public boolean getInstanceEnabledForPartition(String resource, String partition) {
        List<String> oldDisabledPartition = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        Map<String, String> disabledPartitionsMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        return (disabledPartitionsMap == null || !disabledPartitionsMap.containsKey(resource) || !HelixUtil.deserializeByComma(disabledPartitionsMap.get(resource)).contains(partition)) && (oldDisabledPartition == null || !oldDisabledPartition.contains(partition));
    }

    @Deprecated
    public List<String> getDisabledPartitions() {
        List<String> oldDisabled = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        Map<String, String> newDisabledMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        if (newDisabledMap == null && oldDisabled == null) {
            return null;
        }
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (oldDisabled != null) {
            disabledPartitions.addAll(oldDisabled);
        }
        if (newDisabledMap != null) {
            for (String perResource : newDisabledMap.values()) {
                disabledPartitions.addAll(HelixUtil.deserializeByComma(perResource));
            }
        }
        return new ArrayList<String>(disabledPartitions);
    }

    public List<String> getDisabledPartitions(String resourceName) {
        List<String> oldDisabled = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        Map<String, String> newDisabledMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        if (!(newDisabledMap != null && newDisabledMap.containsKey(resourceName) || oldDisabled != null)) {
            return null;
        }
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (oldDisabled != null) {
            disabledPartitions.addAll(oldDisabled);
        }
        if (newDisabledMap != null && newDisabledMap.containsKey(resourceName)) {
            disabledPartitions.addAll(HelixUtil.deserializeByComma(newDisabledMap.get(resourceName)));
        }
        return new ArrayList<String>(disabledPartitions);
    }

    public Map<String, List<String>> getDisabledPartitionsMap() {
        Map<String, String> disabledPartitionsRawMap = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        if (disabledPartitionsRawMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> disabledPartitionsMap = new HashMap<String, List<String>>();
        for (String resourceName : disabledPartitionsRawMap.keySet()) {
            disabledPartitionsMap.put(resourceName, this.getDisabledPartitions(resourceName));
        }
        return disabledPartitionsMap;
    }

    @Deprecated
    public void setInstanceEnabledForPartition(String partitionName, boolean enabled) {
        List<String> list = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (list != null) {
            disabledPartitions.addAll(list);
        }
        if (enabled) {
            disabledPartitions.remove(partitionName);
        } else {
            disabledPartitions.add(partitionName);
        }
        list = new ArrayList<String>(disabledPartitions);
        Collections.sort(list);
        this._record.setListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name(), list);
    }

    public void setInstanceEnabledForPartition(String resourceName, String partitionName, boolean enabled) {
        List<String> oldDisabledPartitions = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        Map<String, String> currentDisabled = this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name());
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (currentDisabled != null && currentDisabled.containsKey(resourceName)) {
            disabledPartitions.addAll(HelixUtil.deserializeByComma(currentDisabled.get(resourceName)));
        }
        if (enabled) {
            disabledPartitions.remove(partitionName);
            if (oldDisabledPartitions != null && oldDisabledPartitions.contains(partitionName)) {
                oldDisabledPartitions.remove(partitionName);
            }
        } else {
            disabledPartitions.add(partitionName);
        }
        ArrayList<String> disabledPartitionList = new ArrayList<String>(disabledPartitions);
        Collections.sort(disabledPartitionList);
        if (currentDisabled == null) {
            currentDisabled = new HashMap<String, String>();
        }
        if (disabledPartitionList != null && !disabledPartitionList.isEmpty()) {
            currentDisabled.put(resourceName, HelixUtil.serializeByComma(disabledPartitionList));
        } else {
            currentDisabled.remove(resourceName);
        }
        if (!currentDisabled.isEmpty()) {
            this._record.setMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name(), currentDisabled);
        }
        if (oldDisabledPartitions != null && !oldDisabledPartitions.isEmpty()) {
            this._record.setListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.name(), oldDisabledPartitions);
        }
    }

    public boolean isInstanceInDomain(String domain) {
        if (domain == null) {
            throw new HelixException("Invalid input for domain.");
        }
        if (this._record.getSimpleField(InstanceConfigProperty.DOMAIN.name()) == null) {
            return false;
        }
        HashSet<String> domainSet = new HashSet<String>(Arrays.asList(domain.split(",")));
        HashSet<String> instanceDomains = new HashSet<String>(Arrays.asList(this._record.getSimpleField(InstanceConfigProperty.DOMAIN.name()).split(",")));
        domainSet.removeAll(instanceDomains);
        return domainSet.size() == 0;
    }

    public boolean isDelayRebalanceEnabled() {
        return this._record.getBooleanField(ResourceConfig.ResourceConfigProperty.DELAY_REBALANCE_ENABLED.name(), true);
    }

    public void setDelayRebalanceEnabled(boolean enabled) {
        this._record.setBooleanField(ResourceConfig.ResourceConfigProperty.DELAY_REBALANCE_ENABLED.name(), enabled);
    }

    public int getMaxConcurrentTask() {
        return this._record.getIntField(InstanceConfigProperty.MAX_CONCURRENT_TASK.name(), -1);
    }

    public void setMaxConcurrentTask(int maxConcurrentTask) {
        this._record.setIntField(InstanceConfigProperty.MAX_CONCURRENT_TASK.name(), maxConcurrentTask);
    }

    public int getTargetTaskThreadPoolSize() {
        return this._record.getIntField(InstanceConfigProperty.TARGET_TASK_THREAD_POOL_SIZE.name(), -1);
    }

    public void setTargetTaskThreadPoolSize(int targetTaskThreadPoolSize) throws IllegalArgumentException {
        if (targetTaskThreadPoolSize < 0) {
            throw new IllegalArgumentException("targetTaskThreadPoolSize must be non-negative!");
        }
        this._record.setIntField(InstanceConfigProperty.TARGET_TASK_THREAD_POOL_SIZE.name(), targetTaskThreadPoolSize);
    }

    public Map<String, String> getInstanceInfoMap() {
        Map<String, String> instanceInfoMap = this._record.getMapField(InstanceConfigProperty.INSTANCE_INFO_MAP.name());
        return instanceInfoMap != null ? instanceInfoMap : Collections.emptyMap();
    }

    private void setInstanceInfoMap(Map<String, String> instanceInfoMap) {
        if (instanceInfoMap == null) {
            this._record.getMapFields().remove(InstanceConfigProperty.INSTANCE_INFO_MAP.name());
        } else {
            this._record.setMapField(InstanceConfigProperty.INSTANCE_INFO_MAP.name(), instanceInfoMap);
        }
    }

    public Map<String, Integer> getInstanceCapacityMap() {
        Map<String, String> capacityData = this._record.getMapField(InstanceConfigProperty.INSTANCE_CAPACITY_MAP.name());
        if (capacityData != null) {
            return capacityData.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> Integer.parseInt((String)entry.getValue())));
        }
        return Collections.emptyMap();
    }

    public void setInstanceCapacityMap(Map<String, Integer> capacityDataMap) throws IllegalArgumentException {
        if (capacityDataMap == null) {
            this._record.getMapFields().remove(InstanceConfigProperty.INSTANCE_CAPACITY_MAP.name());
        } else {
            HashMap<String, String> capacityData = new HashMap<String, String>();
            capacityDataMap.forEach((key, value) -> {
                if (value < 0) {
                    throw new IllegalArgumentException(String.format("Capacity Data contains a negative value: %s = %d", key, value));
                }
                capacityData.put((String)key, Integer.toString(value));
            });
            this._record.setMapField(InstanceConfigProperty.INSTANCE_CAPACITY_MAP.name(), capacityData);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InstanceConfig) {
            InstanceConfig that = (InstanceConfig)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getInstanceName() {
        return this._record.getId();
    }

    public String getLogicalId(String logicalIdKey) {
        return this.getDomainAsMap().getOrDefault(logicalIdKey, this.getInstanceName());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static InstanceConfig toInstanceConfig(String instanceId) {
        char[] delims;
        String host = null;
        int port = -1;
        for (char delim : delims = new char[]{':', '_'}) {
            String regex = String.format("(.*)[%c]([\\d]+)", Character.valueOf(delim));
            if (!((String)instanceId).matches(regex)) continue;
            int lastIndexOf = ((String)instanceId).lastIndexOf(delim);
            try {
                port = Integer.parseInt(((String)instanceId).substring(lastIndexOf + 1));
                host = ((String)instanceId).substring(0, lastIndexOf);
            }
            catch (Exception e) {
                _logger.warn("Unable to extract host and port from instanceId:" + (String)instanceId);
            }
            break;
        }
        if (host != null && port > 0) {
            instanceId = host + "_" + port;
        }
        InstanceConfig config = new InstanceConfig((String)instanceId);
        if (host != null && port > 0) {
            config.setHostName(host);
            config.setPort(String.valueOf(port));
        }
        if (config.getHostName() == null) {
            config.setHostName((String)instanceId);
        }
        return config;
    }

    public boolean validateTopologySettingInInstanceConfig(ClusterConfig clusterConfig, String instanceName) {
        Topology.computeInstanceTopologyMap(clusterConfig, instanceName, this, false);
        return true;
    }

    public void overwriteInstanceConfig(InstanceConfig overwritingInstanceConfig) {
        Set overwritableProperties = Arrays.stream(InstanceConfigProperty.values()).filter(property -> !NON_OVERWRITABLE_PROPERTIES.contains((Object)property)).map(Enum::name).collect(Collectors.toSet());
        this._record.getSimpleFields().keySet().removeAll(overwritableProperties);
        this._record.getListFields().keySet().removeAll(overwritableProperties);
        this._record.getMapFields().keySet().removeAll(overwritableProperties);
        overwritingInstanceConfig.getRecord().getSimpleFields().entrySet().stream().filter(entry -> overwritableProperties.contains(entry.getKey())).forEach(entry -> this._record.setSimpleField((String)entry.getKey(), (String)entry.getValue()));
        overwritingInstanceConfig.getRecord().getListFields().entrySet().stream().filter(entry -> overwritableProperties.contains(entry.getKey())).forEach(entry -> this._record.setListField((String)entry.getKey(), (List)entry.getValue()));
        overwritingInstanceConfig.getRecord().getMapFields().entrySet().stream().filter(entry -> overwritableProperties.contains(entry.getKey())).forEach(entry -> this._record.setMapField((String)entry.getKey(), (Map)entry.getValue()));
    }

    public static class Builder {
        private String _hostName;
        private String _port;
        private String _domain;
        private int _weight = -1;
        private List<String> _tags = new ArrayList<String>();
        private boolean _instanceEnabled = true;
        private InstanceConstants.InstanceOperation _instanceOperation;
        private Map<String, String> _instanceInfoMap;
        private Map<String, Integer> _instanceCapacityMap;

        public InstanceConfig build(String instanceId) {
            InstanceConfig instanceConfig = new InstanceConfig(instanceId);
            String proposedHostName = instanceId;
            String proposedPort = "";
            int lastPos = instanceId.lastIndexOf("_");
            if (lastPos > 0) {
                proposedHostName = instanceId.substring(0, lastPos);
                proposedPort = instanceId.substring(lastPos + 1);
            }
            if (this._hostName != null) {
                instanceConfig.setHostName(this._hostName);
            } else {
                instanceConfig.setHostName(proposedHostName);
            }
            if (this._port != null) {
                instanceConfig.setPort(this._port);
            } else {
                instanceConfig.setPort(proposedPort);
            }
            if (this._domain != null) {
                instanceConfig.setDomain(this._domain);
            }
            if (this._weight != -1) {
                instanceConfig.setWeight(this._weight);
            }
            for (String tag : this._tags) {
                instanceConfig.addTag(tag);
            }
            if (this._instanceOperation == null && !this._instanceEnabled) {
                instanceConfig.setInstanceOperationInit(InstanceConstants.InstanceOperation.DISABLE);
            }
            if (this._instanceOperation != null && !this._instanceOperation.equals((Object)InstanceConstants.InstanceOperation.ENABLE)) {
                instanceConfig.setInstanceOperationInit(this._instanceOperation);
            }
            if (this._instanceInfoMap != null) {
                instanceConfig.setInstanceInfoMap(this._instanceInfoMap);
            }
            if (this._instanceCapacityMap != null) {
                instanceConfig.setInstanceCapacityMap(this._instanceCapacityMap);
            }
            return instanceConfig;
        }

        public Builder setHostName(String hostName) {
            this._hostName = hostName;
            return this;
        }

        public Builder setPort(String port) {
            this._port = port;
            return this;
        }

        public Builder setDomain(String domain) {
            this._domain = domain;
            return this;
        }

        public Builder setWeight(int weight) {
            this._weight = weight;
            return this;
        }

        public Builder addTag(String tag) {
            this._tags.add(tag);
            return this;
        }

        @Deprecated
        public Builder setInstanceEnabled(boolean instanceEnabled) {
            this._instanceEnabled = instanceEnabled;
            return this;
        }

        public Builder setInstanceOperation(InstanceConstants.InstanceOperation instanceOperation) {
            this._instanceOperation = instanceOperation;
            return this;
        }

        public Builder setInstanceInfoMap(Map<String, String> instanceInfoMap) {
            this._instanceInfoMap = instanceInfoMap;
            return this;
        }

        public Builder addInstanceInfo(String key, String value) {
            if (this._instanceInfoMap == null) {
                this._instanceInfoMap = new HashMap<String, String>();
            }
            this._instanceInfoMap.putIfAbsent(key, value);
            return this;
        }

        public Builder setInstanceCapacityMap(Map<String, Integer> instanceCapacityMap) {
            this._instanceCapacityMap = instanceCapacityMap;
            return this;
        }
    }

    public static class InstanceOperation {
        private final Map<String, String> _properties;

        private InstanceOperation(@Nullable Map<String, String> properties) {
            HashMap hashMap = this._properties = properties == null ? new HashMap() : properties;
            if (!this._properties.containsKey(InstanceOperationProperties.OPERATION.name())) {
                this._properties.put(InstanceOperationProperties.OPERATION.name(), InstanceConstants.InstanceOperation.ENABLE.name());
            }
        }

        public InstanceConstants.InstanceOperation getOperation() throws IllegalArgumentException {
            return InstanceConstants.InstanceOperation.valueOf(this._properties.get(InstanceOperationProperties.OPERATION.name()));
        }

        public String getReason() {
            return this._properties.getOrDefault(InstanceOperationProperties.REASON.name(), "");
        }

        public InstanceConstants.InstanceOperationSource getSource() {
            return InstanceConstants.InstanceOperationSource.valueOf(this._properties.getOrDefault(InstanceOperationProperties.SOURCE.name(), InstanceConstants.InstanceOperationSource.USER.name()));
        }

        public long getTimestamp() {
            return Long.parseLong(this._properties.get(InstanceOperationProperties.TIMESTAMP.name()));
        }

        private void setTimestamp(long timestamp) {
            this._properties.put(InstanceOperationProperties.TIMESTAMP.name(), String.valueOf(timestamp));
        }

        private Map<String, String> getProperties() {
            return this._properties;
        }

        public static class Builder {
            private Map<String, String> _properties = new HashMap<String, String>();

            public Builder setOperation(@Nullable InstanceConstants.InstanceOperation operationType) {
                this._properties.put(InstanceOperationProperties.OPERATION.name(), operationType == null ? InstanceConstants.InstanceOperation.ENABLE.name() : operationType.name());
                return this;
            }

            public Builder setReason(String reason) {
                this._properties.put(InstanceOperationProperties.REASON.name(), reason != null ? reason : "");
                return this;
            }

            public Builder setSource(InstanceConstants.InstanceOperationSource source) {
                this._properties.put(InstanceOperationProperties.SOURCE.name(), source == null ? InstanceConstants.InstanceOperationSource.USER.name() : source.name());
                return this;
            }

            public InstanceOperation build() throws IllegalArgumentException {
                if (!this._properties.containsKey(InstanceOperationProperties.OPERATION.name())) {
                    throw new IllegalArgumentException("Instance operation type is not set, this is a required field.");
                }
                this._properties.put(InstanceOperationProperties.TIMESTAMP.name(), String.valueOf(System.currentTimeMillis()));
                return new InstanceOperation(this._properties);
            }
        }

        private static enum InstanceOperationProperties {
            OPERATION,
            REASON,
            SOURCE,
            TIMESTAMP;

        }
    }

    public static enum InstanceConfigProperty {
        HELIX_HOST,
        HELIX_PORT,
        HELIX_ZONE_ID,
        HELIX_ENABLED,
        HELIX_ENABLED_TIMESTAMP,
        HELIX_DISABLED_REASON,
        HELIX_DISABLED_TYPE,
        HELIX_DISABLED_PARTITION,
        TAG_LIST,
        INSTANCE_WEIGHT,
        DOMAIN,
        DELAY_REBALANCE_ENABLED,
        MAX_CONCURRENT_TASK,
        INSTANCE_INFO_MAP,
        INSTANCE_CAPACITY_MAP,
        TARGET_TASK_THREAD_POOL_SIZE,
        HELIX_INSTANCE_OPERATIONS;

    }
}

