/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.MessageOutput;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.ConstraintItem;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageThrottleStage
extends AbstractBaseStage {
    private static final Logger LOG = LoggerFactory.getLogger((String)MessageThrottleStage.class.getName());

    int valueOf(String valueStr) {
        int value = Integer.MAX_VALUE;
        try {
            ClusterConstraints.ConstraintValue valueToken = ClusterConstraints.ConstraintValue.valueOf(valueStr);
            switch (valueToken) {
                case ANY: {
                    value = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    LogUtil.logError(LOG, this._eventId, "Invalid constraintValue token:" + valueStr + ". Use default value:2147483647");
                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException ne) {
                LogUtil.logError(LOG, this._eventId, "Invalid constraintValue string:" + valueStr + ". Use default value:2147483647");
            }
        }
        return value;
    }

    Set<ConstraintItem> selectConstraints(Set<ConstraintItem> items, Map<ClusterConstraints.ConstraintAttribute, String> attributes) {
        HashMap<String, ConstraintItem> selectedItems = new HashMap<String, ConstraintItem>();
        for (ConstraintItem item : items) {
            int existingValue;
            if (item.getConstraintValue().equals(ClusterConstraints.ConstraintValue.ANY.toString())) continue;
            String key = item.filter(attributes).toString();
            if (!selectedItems.containsKey(key)) {
                selectedItems.put(key, item);
                continue;
            }
            ConstraintItem existingItem = (ConstraintItem)selectedItems.get(key);
            if (existingItem.match(item.getAttributes())) {
                selectedItems.put(key, item);
                continue;
            }
            if (item.match(existingItem.getAttributes())) continue;
            int value = this.valueOf(item.getConstraintValue());
            if (value < (existingValue = this.valueOf(existingItem.getConstraintValue()))) {
                selectedItems.put(key, item);
                continue;
            }
            if (value != existingValue || item.toString().compareTo(existingItem.toString()) >= 0) continue;
            selectedItems.put(key, item);
        }
        return new HashSet<ConstraintItem>(selectedItems.values());
    }

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        MessageOutput msgSelectionOutput = (MessageOutput)event.getAttribute(AttributeName.MESSAGES_SELECTED.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        if (cache == null || resourceMap == null || msgSelectionOutput == null) {
            throw new StageException("Missing attributes in event: " + event + ". Requires ResourceControllerDataProvider|RESOURCES|MESSAGES_SELECTED");
        }
        MessageOutput output = new MessageOutput();
        ClusterConstraints constraint = cache.getConstraint(ClusterConstraints.ConstraintType.MESSAGE_CONSTRAINT);
        HashMap<String, Integer> throttleCounterMap = new HashMap<String, Integer>();
        if (constraint != null) {
            for (String instance : cache.getLiveInstances().keySet()) {
                this.throttle(throttleCounterMap, constraint, new ArrayList<Message>(cache.getMessages(instance).values()), false);
            }
        }
        for (String resourceName : resourceMap.keySet()) {
            Resource resource = (Resource)resourceMap.get(resourceName);
            for (Partition partition : resource.getPartitions()) {
                List<Message> messages = msgSelectionOutput.getMessages(resourceName, partition);
                if (constraint != null && messages != null && messages.size() > 0) {
                    messages = this.throttle(throttleCounterMap, constraint, messages, true);
                }
                output.addMessages(resourceName, partition, messages);
            }
        }
        event.addAttribute(AttributeName.MESSAGES_THROTTLE.name(), output);
    }

    private List<Message> throttle(Map<String, Integer> throttleMap, ClusterConstraints constraint, List<Message> messages, boolean needThrottle) {
        ArrayList<Message> throttleOutputMsgs = new ArrayList<Message>();
        for (Message message : messages) {
            Map<ClusterConstraints.ConstraintAttribute, String> msgAttr = ClusterConstraints.toConstraintAttributes(message);
            Set<ConstraintItem> matches = constraint.match(msgAttr);
            matches = this.selectConstraints(matches, msgAttr);
            boolean msgThrottled = false;
            for (ConstraintItem item : matches) {
                String key = item.filter(msgAttr).toString();
                if (!throttleMap.containsKey(key)) {
                    throttleMap.put(key, this.valueOf(item.getConstraintValue()));
                }
                int value = throttleMap.get(key);
                throttleMap.put(key, --value);
                if (!needThrottle || value >= 0) continue;
                msgThrottled = true;
                if (!LOG.isDebugEnabled()) continue;
                LogUtil.logDebug(LOG, this._eventId, "message: " + message + " is throttled by constraint: " + item);
            }
            if (msgThrottled) continue;
            throttleOutputMsgs.add(message);
        }
        return throttleOutputMsgs;
    }
}

