/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.event;

import com.ecwid.consul.ConsulRequest;
import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.v1.QueryParams;
import java.util.ArrayList;
import java.util.List;

public final class EventListRequest
implements ConsulRequest {
    private final String name;
    private final String node;
    private final String service;
    private final String tag;
    private final QueryParams queryParams;
    private final String token;

    private EventListRequest(String name, String node, String service, String tag, QueryParams queryParams, String token) {
        this.name = name;
        this.node = node;
        this.service = service;
        this.tag = tag;
        this.queryParams = queryParams;
        this.token = token;
    }

    public String getName() {
        return this.name;
    }

    public String getNode() {
        return this.node;
    }

    public String getService() {
        return this.service;
    }

    public String getTag() {
        return this.tag;
    }

    public QueryParams getQueryParams() {
        return this.queryParams;
    }

    public String getToken() {
        return this.token;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public List<UrlParameters> asUrlParameters() {
        ArrayList<UrlParameters> params = new ArrayList<UrlParameters>();
        if (this.name != null) {
            params.add(new SingleUrlParameters("name", this.name));
        }
        if (this.node != null) {
            params.add(new SingleUrlParameters("node", this.node));
        }
        if (this.service != null) {
            params.add(new SingleUrlParameters("service", this.service));
        }
        if (this.tag != null) {
            params.add(new SingleUrlParameters("tag", this.tag));
        }
        if (this.queryParams != null) {
            params.add(this.queryParams);
        }
        if (this.token != null) {
            params.add(new SingleUrlParameters("token", this.token));
        }
        return params;
    }

    public static class Builder {
        private String name;
        private String node;
        private String service;
        private String tag;
        private QueryParams queryParams;
        private String token;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setNode(String node) {
            this.node = node;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setQueryParams(QueryParams queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public EventListRequest build() {
            return new EventListRequest(this.name, this.node, this.service, this.tag, this.queryParams, this.token);
        }
    }
}

