/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.connection.BufferProvider;
import com.mongodb.internal.connection.ConcurrentPool;
import com.mongodb.internal.thread.DaemonThreadFactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;

public class PowerOfTwoBufferPool
implements BufferProvider {
    public static final PowerOfTwoBufferPool DEFAULT = new PowerOfTwoBufferPool().enablePruning();
    private final Map<Integer, ConcurrentPool<IdleTrackingByteBuffer>> powerOfTwoToPoolMap = new HashMap<Integer, ConcurrentPool<IdleTrackingByteBuffer>>();
    private final long maxIdleTimeNanos;
    private final ScheduledExecutorService pruner;

    PowerOfTwoBufferPool() {
        this(24);
    }

    PowerOfTwoBufferPool(int highestPowerOfTwo) {
        this(highestPowerOfTwo, 1L, TimeUnit.MINUTES);
    }

    PowerOfTwoBufferPool(int highestPowerOfTwo, long maxIdleTime, TimeUnit timeUnit) {
        int powerOfTwo = 1;
        for (int i = 0; i <= highestPowerOfTwo; ++i) {
            int size = powerOfTwo;
            this.powerOfTwoToPoolMap.put(i, new ConcurrentPool<IdleTrackingByteBuffer>(Integer.MAX_VALUE, new ItemFactory(size)));
            powerOfTwo <<= 1;
        }
        this.maxIdleTimeNanos = timeUnit.toNanos(maxIdleTime);
        this.pruner = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("BufferPoolPruner"));
    }

    PowerOfTwoBufferPool enablePruning() {
        this.pruner.scheduleAtFixedRate(this::prune, this.maxIdleTimeNanos, this.maxIdleTimeNanos / 2L, TimeUnit.NANOSECONDS);
        return this;
    }

    void disablePruning() {
        this.pruner.shutdownNow();
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return new PooledByteBufNIO(this.getByteBuffer(size));
    }

    public ByteBuffer getByteBuffer(int size) {
        ConcurrentPool<IdleTrackingByteBuffer> pool = this.powerOfTwoToPoolMap.get(PowerOfTwoBufferPool.log2(PowerOfTwoBufferPool.roundUpToNextHighestPowerOfTwo(size)));
        ByteBuffer byteBuffer = pool == null ? this.createNew(size) : pool.get().getBuffer();
        ((Buffer)byteBuffer).clear();
        ((Buffer)byteBuffer).limit(size);
        return byteBuffer;
    }

    private ByteBuffer createNew(int size) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    public void release(ByteBuffer buffer) {
        ConcurrentPool<IdleTrackingByteBuffer> pool = this.powerOfTwoToPoolMap.get(PowerOfTwoBufferPool.log2(PowerOfTwoBufferPool.roundUpToNextHighestPowerOfTwo(buffer.capacity())));
        if (pool != null) {
            pool.release(new IdleTrackingByteBuffer(buffer));
        }
    }

    private void prune() {
        this.powerOfTwoToPoolMap.values().forEach(ConcurrentPool::prune);
    }

    static int log2(int powerOfTwo) {
        return 31 - Integer.numberOfLeadingZeros(powerOfTwo);
    }

    static int roundUpToNextHighestPowerOfTwo(int size) {
        int v = size;
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    private final class ItemFactory
    implements ConcurrentPool.ItemFactory<IdleTrackingByteBuffer> {
        private final int size;

        private ItemFactory(int size) {
            this.size = size;
        }

        @Override
        public IdleTrackingByteBuffer create() {
            return new IdleTrackingByteBuffer(PowerOfTwoBufferPool.this.createNew(this.size));
        }

        @Override
        public void close(IdleTrackingByteBuffer idleTrackingByteBuffer) {
        }

        @Override
        public ConcurrentPool.Prune shouldPrune(IdleTrackingByteBuffer idleTrackingByteBuffer) {
            return System.nanoTime() - idleTrackingByteBuffer.getLastUsedNanos() >= PowerOfTwoBufferPool.this.maxIdleTimeNanos ? ConcurrentPool.Prune.YES : ConcurrentPool.Prune.STOP;
        }
    }

    private class PooledByteBufNIO
    extends ByteBufNIO {
        PooledByteBufNIO(ByteBuffer buf) {
            super(buf);
        }

        public void release() {
            ByteBuffer wrapped = this.asNIO();
            super.release();
            if (this.getReferenceCount() == 0) {
                PowerOfTwoBufferPool.this.release(wrapped);
            }
        }
    }

    private static final class IdleTrackingByteBuffer {
        private final long lastUsedNanos = System.nanoTime();
        private final ByteBuffer buffer;

        private IdleTrackingByteBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public long getLastUsedNanos() {
            return this.lastUsedNanos;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }
    }
}

