/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.protocol;

import com.facebook.thrift.TApplicationException;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TCompactProtocol;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TMessage;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.protocol.TSet;
import com.facebook.thrift.protocol.TStruct;
import com.facebook.thrift.transport.THeaderException;
import com.facebook.thrift.transport.THeaderTransport;
import com.facebook.thrift.transport.TTransport;
import java.util.List;
import java.util.Map;

public class THeaderProtocol
extends TProtocol {
    private TProtocol proto;
    private int protoId;

    private void resetProtocol() throws TProtocolException {
        if (this.proto != null && this.protoId == ((THeaderTransport)this.trans_).getProtocolId()) {
            return;
        }
        this.protoId = ((THeaderTransport)this.trans_).getProtocolId();
        switch (this.protoId) {
            case 0: {
                this.proto = new TBinaryProtocol(this.trans_, true, true);
                break;
            }
            case 2: {
                this.proto = new TCompactProtocol(this.trans_);
                break;
            }
            default: {
                throw new TProtocolException("Unknown protocol id: " + this.protoId);
            }
        }
    }

    public THeaderProtocol(TTransport trans, List<THeaderTransport.ClientTypes> clientTypes) {
        this(new THeaderTransport(trans, clientTypes));
    }

    public THeaderProtocol(THeaderTransport trans) {
        super(trans);
        try {
            this.resetProtocol();
        }
        catch (TProtocolException tpe) {
            throw new RuntimeException(tpe);
        }
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        this.proto.writeMessageBegin(message);
    }

    @Override
    public void writeMessageEnd() throws TException {
        this.proto.writeMessageEnd();
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        this.proto.writeStructBegin(struct);
    }

    @Override
    public void writeStructEnd() throws TException {
        this.proto.writeStructEnd();
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        this.proto.writeFieldBegin(field);
    }

    @Override
    public void writeFieldEnd() throws TException {
        this.proto.writeFieldEnd();
    }

    @Override
    public void writeFieldStop() throws TException {
        this.proto.writeFieldStop();
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        this.proto.writeMapBegin(map);
    }

    @Override
    public void writeMapEnd() throws TException {
        this.proto.writeMapEnd();
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.proto.writeListBegin(list);
    }

    @Override
    public void writeListEnd() throws TException {
        this.proto.writeListEnd();
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.proto.writeSetBegin(set);
    }

    @Override
    public void writeSetEnd() throws TException {
        this.proto.writeSetEnd();
    }

    @Override
    public void writeBool(boolean b) throws TException {
        this.proto.writeBool(b);
    }

    @Override
    public void writeByte(byte b) throws TException {
        this.proto.writeByte(b);
    }

    @Override
    public void writeI16(short i16) throws TException {
        this.proto.writeI16(i16);
    }

    @Override
    public void writeI32(int i32) throws TException {
        this.proto.writeI32(i32);
    }

    @Override
    public void writeI64(long i64) throws TException {
        this.proto.writeI64(i64);
    }

    @Override
    public void writeDouble(double dub) throws TException {
        this.proto.writeDouble(dub);
    }

    @Override
    public void writeFloat(float flt) throws TException {
        this.proto.writeFloat(flt);
    }

    @Override
    public void writeString(String str) throws TException {
        this.proto.writeString(str);
    }

    @Override
    public void writeBinary(byte[] bin) throws TException {
        this.proto.writeBinary(bin);
    }

    public void notifyEndpoint(String msg) throws TException {
        if (this.proto != null) {
            this.writeMessageBegin(new TMessage("", 3, 0));
            TApplicationException ex = new TApplicationException(msg);
            ex.write(this);
            this.writeMessageEnd();
            this.trans_.flush();
        }
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        try {
            ((THeaderTransport)this.trans_)._resetProtocol();
            this.resetProtocol();
        }
        catch (THeaderException e) {
            this.notifyEndpoint(e.toString());
        }
        return this.proto.readMessageBegin();
    }

    @Override
    public void readMessageEnd() throws TException {
        this.proto.readMessageEnd();
    }

    @Override
    public TStruct readStructBegin(Map<Integer, FieldMetaData> metaDataMap) throws TException {
        return this.proto.readStructBegin(metaDataMap);
    }

    @Override
    public void readStructEnd() throws TException {
        this.proto.readStructEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        return this.proto.readFieldBegin();
    }

    @Override
    public void readFieldEnd() throws TException {
        this.proto.readFieldEnd();
    }

    @Override
    public TMap readMapBegin() throws TException {
        return this.proto.readMapBegin();
    }

    @Override
    public void readMapEnd() throws TException {
        this.proto.readMapEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        return this.proto.readListBegin();
    }

    @Override
    public void readListEnd() throws TException {
        this.proto.readListEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        return this.proto.readSetBegin();
    }

    @Override
    public void readSetEnd() throws TException {
        this.proto.readSetEnd();
    }

    @Override
    public boolean readBool() throws TException {
        return this.proto.readBool();
    }

    @Override
    public byte readByte() throws TException {
        return this.proto.readByte();
    }

    @Override
    public short readI16() throws TException {
        return this.proto.readI16();
    }

    @Override
    public int readI32() throws TException {
        return this.proto.readI32();
    }

    @Override
    public long readI64() throws TException {
        return this.proto.readI64();
    }

    @Override
    public double readDouble() throws TException {
        return this.proto.readDouble();
    }

    @Override
    public float readFloat() throws TException {
        return this.proto.readFloat();
    }

    @Override
    public String readString() throws TException {
        return this.proto.readString();
    }

    @Override
    public byte[] readBinary() throws TException {
        return this.proto.readBinary();
    }

    public static class Factory
    implements TProtocolFactory {
        List<THeaderTransport.ClientTypes> clientTypes;

        public Factory(List<THeaderTransport.ClientTypes> clientTypes) {
            this.clientTypes = clientTypes;
        }

        public Factory() {
        }

        @Override
        public TProtocol getProtocol(TTransport trans) {
            if (trans instanceof THeaderTransport) {
                return new THeaderProtocol((THeaderTransport)trans);
            }
            return new THeaderProtocol(trans, this.clientTypes);
        }
    }
}

