/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.encoder;

import com.vesoft.nebula.PropertyType;
import com.vesoft.nebula.encoder.SchemaProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaProviderImpl
implements SchemaProvider {
    private final long ver;
    private final List<SchemaProvider.Field> fields = new ArrayList<SchemaProvider.Field>();
    private final Map<String, Integer> fieldNameIndex = new HashMap<String, Integer>();
    private int numNullableFields = 0;

    public SchemaProviderImpl(long ver) {
        this.ver = ver;
    }

    @Override
    public long getVersion() {
        return this.ver;
    }

    @Override
    public int getNumFields() {
        return this.fields.size();
    }

    @Override
    public int getNumNullableFields() {
        return this.numNullableFields;
    }

    @Override
    public int size() {
        if (this.fields.size() > 0) {
            SchemaProvider.Field lastField = this.fields.get(this.fields.size() - 1);
            return lastField.offset() + lastField.size();
        }
        return 0;
    }

    @Override
    public int getFieldIndex(String name) {
        return this.fieldNameIndex.getOrDefault(name, -1);
    }

    @Override
    public String getFiledName(int index) {
        if (index < 0 || index >= this.fields.size()) {
            throw new RuntimeException("Index[" + index + "] is out of range[0-" + this.fields.size() + "]");
        }
        return this.fields.get(index).name();
    }

    @Override
    public int getFiledType(int index) {
        if (index < 0 || index >= this.fields.size()) {
            throw new RuntimeException("Index[" + index + "] is out of range[0-" + this.fields.size() + "]");
        }
        return this.fields.get(index).type();
    }

    @Override
    public int getFiledType(String name) {
        if (!this.fieldNameIndex.containsKey(name)) {
            return -1;
        }
        return this.fields.get(this.fieldNameIndex.get(name)).type();
    }

    @Override
    public SchemaProvider.Field field(int index) {
        if (index < 0 || index >= this.fields.size()) {
            throw new RuntimeException("Invalid index " + index);
        }
        return this.fields.get(index);
    }

    @Override
    public SchemaProvider.Field field(String name) {
        if (!this.fieldNameIndex.containsKey(name)) {
            throw new RuntimeException("Unknown field \"" + name + "\"");
        }
        return this.fields.get(this.fieldNameIndex.get(name));
    }

    public void addField(String name, int type, int fixedStrLen, boolean nullable, byte[] defaultValue, int geoShape) {
        int size = this.fieldSize(type, fixedStrLen);
        int offset = 0;
        if (this.fields.size() > 0) {
            SchemaProvider.Field lastField = this.fields.get(this.fields.size() - 1);
            offset = lastField.offset() + lastField.size();
        }
        int nullFlagPos = 0;
        if (nullable) {
            nullFlagPos = this.numNullableFields++;
        }
        this.fields.add(new SchemaField(name, type, nullable, defaultValue != null, defaultValue, size, offset, nullFlagPos, geoShape));
        this.fieldNameIndex.put(name, this.fields.size() - 1);
    }

    @Override
    public int fieldSize(int type, int fixedStrLimit) {
        PropertyType typeEnum = PropertyType.findByValue(type);
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + type);
        }
        switch (typeEnum) {
            case BOOL: {
                return 1;
            }
            case VID: 
            case INT64: 
            case TIMESTAMP: {
                return 8;
            }
            case INT32: {
                return 4;
            }
            case INT16: {
                return 2;
            }
            case INT8: {
                return 1;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 8;
            }
            case FIXED_STRING: {
                if (fixedStrLimit < 0) {
                    throw new RuntimeException("Fixed string length must be greater than zero");
                }
                return fixedStrLimit;
            }
            case DATE: {
                return 4;
            }
            case TIME: {
                return 7;
            }
            case DATETIME: {
                return 11;
            }
            case GEOGRAPHY: {
                return 8;
            }
        }
        throw new RuntimeException("Incorrect field type " + type);
    }

    static class SchemaField
    implements SchemaProvider.Field {
        private final String name;
        private final int type;
        private final boolean nullable;
        private final boolean hasDefault;
        private final byte[] defaultValue;
        private final int size;
        private final int offset;
        private final int nullFlagPos;
        private final int geoShape;

        public SchemaField(String name, int type, boolean nullable, boolean hasDefault, byte[] defaultValue, int size, int offset, int nullFlagPos, int geoShape) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.hasDefault = hasDefault;
            this.defaultValue = defaultValue;
            this.size = size;
            this.offset = offset;
            this.nullFlagPos = nullFlagPos;
            this.geoShape = geoShape;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public boolean hasDefault() {
            return this.hasDefault;
        }

        @Override
        public byte[] defaultValue() {
            return this.defaultValue;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int offset() {
            return this.offset;
        }

        @Override
        public int nullFlagPos() {
            return this.nullFlagPos;
        }

        @Override
        public int geoShape() {
            return this.geoShape;
        }
    }
}

