/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.compression;

import java.util.EnumMap;
import java.util.ServiceLoader;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.compression.CompressionUtil;
import org.apache.arrow.vector.compression.NoCompressionCodec;

public interface CompressionCodec {
    public ArrowBuf compress(BufferAllocator var1, ArrowBuf var2);

    public ArrowBuf decompress(BufferAllocator var1, ArrowBuf var2);

    public CompressionUtil.CodecType getCodecType();

    public static interface Factory {
        public static final Factory INSTANCE = Factory.bestEffort();

        public CompressionCodec createCodec(CompressionUtil.CodecType var1);

        public CompressionCodec createCodec(CompressionUtil.CodecType var1, int var2);

        private static Factory bestEffort() {
            ServiceLoader<Factory> serviceLoader = ServiceLoader.load(Factory.class);
            final EnumMap<CompressionUtil.CodecType, Factory> factories = new EnumMap<CompressionUtil.CodecType, Factory>(CompressionUtil.CodecType.class);
            for (Factory factory : serviceLoader) {
                for (CompressionUtil.CodecType codecType : CompressionUtil.CodecType.values()) {
                    try {
                        factory.createCodec(codecType);
                        factories.putIfAbsent(codecType, factory);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            final NoCompressionCodec.Factory fallback = NoCompressionCodec.Factory.INSTANCE;
            return new Factory(){

                @Override
                public CompressionCodec createCodec(CompressionUtil.CodecType codecType) {
                    return factories.getOrDefault((Object)codecType, fallback).createCodec(codecType);
                }

                @Override
                public CompressionCodec createCodec(CompressionUtil.CodecType codecType, int compressionLevel) {
                    return factories.getOrDefault((Object)codecType, fallback).createCodec(codecType, compressionLevel);
                }
            };
        }
    }
}

