/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ftp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.FtpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FtpCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(FtpCollectImpl.class);
    private static final String ANONYMOUS = "anonymous";
    private static final String PASSWORD = "password";

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getFtp() == null) {
            throw new IllegalArgumentException("Ftp collect must has ftp params.");
        }
        FtpProtocol ftpProtocol = metrics.getFtp();
        Assert.hasText((String)ftpProtocol.getHost(), (String)"Ftp Protocol host is required.");
        Assert.hasText((String)ftpProtocol.getPort(), (String)"Ftp Protocol port is required.");
        Assert.hasText((String)ftpProtocol.getDirection(), (String)"Ftp Protocol direction is required.");
        Assert.hasText((String)ftpProtocol.getTimeout(), (String)"Ftp Protocol timeout is required.");
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        boolean ssl = Boolean.parseBoolean(metrics.getFtp().getSsl());
        if (ssl) {
            this.handleSftpCollect(builder, metrics);
        } else {
            this.handleFtpCollect(builder, metrics);
        }
    }

    private Map<String, String> collectValue(FTPClient ftpClient, FtpProtocol ftpProtocol) {
        String responseTime;
        boolean isActive;
        try {
            long startTime = System.currentTimeMillis();
            this.connect(ftpClient, ftpProtocol);
            this.login(ftpClient, ftpProtocol);
            isActive = ftpClient.changeWorkingDirectory(ftpProtocol.getDirection());
            long endTime = System.currentTimeMillis();
            responseTime = String.valueOf(endTime - startTime);
            ftpClient.disconnect();
        }
        catch (Exception e) {
            log.info("[FTPClient] error: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e), (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return new HashMap<String, String>(8){
            {
                super(initialCapacity);
                this.put("isActive", Boolean.toString(isActive));
                this.put("responseTime", responseTime);
            }
        };
    }

    private Map<String, String> collectValue(SftpClient sftpClient, FtpProtocol ftpProtocol) {
        String responseTime;
        boolean isActive;
        try {
            long startTime = System.currentTimeMillis();
            sftpClient.stat(ftpProtocol.getDirection());
            isActive = true;
            long endTime = System.currentTimeMillis();
            responseTime = String.valueOf(endTime - startTime);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("[SFTPClient] error: {}" + CommonUtil.getMessageFromThrowable((Throwable)e), e);
        }
        return Map.of("isActive", Boolean.toString(isActive), "responseTime", responseTime);
    }

    private void login(FTPClient ftpClient, FtpProtocol ftpProtocol) {
        try {
            if (StringUtils.hasText((String)ftpProtocol.getUsername()) && StringUtils.hasText((String)ftpProtocol.getPassword())) {
                if (!ftpClient.login(ftpProtocol.getUsername(), ftpProtocol.getPassword())) {
                    throw new IllegalArgumentException("The username or password may be wrong.");
                }
                return;
            }
            if (!ftpClient.login(ANONYMOUS, PASSWORD)) {
                throw new IllegalArgumentException("The server may not allow anonymous access, we need to username and password.");
            }
        }
        catch (Exception e) {
            log.info("[ftp login] error: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e), (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void connect(FTPClient ftpClient, FtpProtocol ftpProtocol) {
        try {
            ftpClient.connect(ftpProtocol.getHost(), Integer.parseInt(ftpProtocol.getPort()));
        }
        catch (Exception e) {
            log.info("[ftp connection] error: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e), (Object)e);
            throw new IllegalArgumentException("The host or port may be wrong.");
        }
    }

    private ClientSession connect(SshClient client, FtpProtocol ftpProtocol) {
        client.start();
        try {
            ClientSession session = (ClientSession)((ConnectFuture)client.connect(ftpProtocol.getUsername(), ftpProtocol.getHost(), Integer.parseInt(ftpProtocol.getPort())).verify((long)Integer.parseInt(ftpProtocol.getTimeout()))).getSession();
            session.addPasswordIdentity(ftpProtocol.getPassword());
            session.auth().verify((long)Integer.parseInt(ftpProtocol.getTimeout()));
            return session;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("[sftp connection] error: {}" + CommonUtil.getMessageFromThrowable((Throwable)e), e);
        }
    }

    public String supportProtocol() {
        return "ftp";
    }

    private void handleFtpCollect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        FTPClient ftpClient = new FTPClient();
        FtpProtocol ftpProtocol = metrics.getFtp();
        ftpClient.setControlKeepAliveReplyTimeout(Integer.parseInt(ftpProtocol.getTimeout()));
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        try {
            Map<String, String> valueMap = this.collectValue(ftpClient, ftpProtocol);
            metrics.getAliasFields().forEach(it -> {
                if (valueMap.containsKey(it)) {
                    String fieldValue = (String)valueMap.get(it);
                    valueRowBuilder.addColumn(Objects.requireNonNullElse(fieldValue, "&nbsp;"));
                } else {
                    valueRowBuilder.addColumn("&nbsp;");
                }
            });
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(e.getMessage());
            return;
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSftpCollect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        FtpProtocol ftpProtocol = metrics.getFtp();
        ClientSession session = null;
        SftpClient sftpClient = null;
        SshClient client = null;
        try {
            client = SshClient.setUpDefaultClient();
            session = this.connect(client, ftpProtocol);
            sftpClient = SftpClientFactory.instance().createSftpClient(session);
            Map<String, String> valueMap = this.collectValue(sftpClient, ftpProtocol);
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            metrics.getAliasFields().forEach(it -> valueRowBuilder.addColumn(valueMap.getOrDefault(it, "&nbsp;")));
            builder.addValueRow(valueRowBuilder.build());
        }
        catch (Exception e) {
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg(e.getMessage());
        }
        finally {
            try {
                if (sftpClient != null && sftpClient.isOpen()) {
                    sftpClient.close();
                }
                if (session != null && session.isOpen()) {
                    session.close();
                }
                if (client != null && client.isOpen()) {
                    client.close();
                }
            }
            catch (Exception e) {
                log.error("[SFTPClient] error while closing: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e), (Object)e);
            }
        }
    }
}

