/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.hertzbeat.collector.collect.ipmi2.client.handler.ChassisHandler;
import org.apache.hertzbeat.collector.collect.ipmi2.client.handler.IpmiHandler;
import org.apache.hertzbeat.collector.collect.ipmi2.client.handler.SensorHandler;

public class IpmiHandlerManager {
    Map<String, IpmiHandler> handlerMap = new HashMap<String, IpmiHandler>();

    public IpmiHandlerManager() {
        this.registerHandler("Chassis", new ChassisHandler());
        this.registerHandler("Sensor", new SensorHandler());
    }

    public void registerHandler(String metricName, IpmiHandler handler) {
        this.handlerMap.put(metricName, handler);
    }

    public IpmiHandler getHandler(String metricName) {
        if (!this.handlerMap.containsKey(metricName)) {
            return null;
        }
        return this.handlerMap.get(metricName);
    }
}

