/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.IpmiCommand;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.IpmiResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiNetworkFunctionCode implements IpmiCode.Code
{
    Chassis(0),
    Bridge(2),
    Sensor_Event(4),
    App(6),
    Firmware(8),
    Storage(10),
    Transport(12),
    GroupExtension(44),
    OEM_Group(46);

    private final byte code;
    public static final int MASK = 63;

    private IpmiNetworkFunctionCode(int code) {
        this.code = ByteConvertUtils.checkCastByte(code);
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public int getCode(IpmiCommand command) {
        if (command instanceof IpmiResponse) {
            return this.code | 1;
        }
        return this.code;
    }
}

