/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.rmcp;

import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.AbstractWireable;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiEncapsulation;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.Ipmi20Ipv4SessionWrapper;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiSessionAuthenticationType;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.rmcp.Packet;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.rmcp.RmcpData;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.rmcp.RmcpMessageClass;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.rmcp.RmcpMessageStatus;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.rmcp.RmcpVersion;

public class RmcpPacket
extends AbstractWireable
implements Packet {
    protected static final int RMCP_HEADER_LENGTH = 4;
    private final RmcpVersion version = RmcpVersion.ASF_RMCP_1_0;
    private byte sequenceNumber = (byte)-1;
    private RmcpMessageClass messageClass;
    private RmcpMessageStatus messageRole = RmcpMessageStatus.REQ;
    private RmcpData data;

    public RmcpVersion getVersion() {
        return this.version;
    }

    public byte getSequenceNumber() {
        return this.sequenceNumber;
    }

    public RmcpMessageClass getMessageClass() {
        return this.messageClass;
    }

    public RmcpPacket withMessageClass(RmcpMessageClass messageClass) {
        this.messageClass = messageClass;
        return this;
    }

    public RmcpMessageStatus getMessageRole() {
        return this.messageRole;
    }

    @Override
    public RmcpData getData() {
        return this.data;
    }

    @Override
    public <T extends RmcpData> T getData(Class<T> type) {
        return (T)((RmcpData)type.cast(this.getData()));
    }

    @Override
    public Packet withData(RmcpData data) {
        this.withMessageClass(data.getMessageClass());
        this.data = data;
        return this;
    }

    @Override
    public <T> T getEncapsulated(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        return IpmiEncapsulation.getEncapsulated(type, this.getData());
    }

    private void toWireHeader(ByteBuffer buffer) {
        buffer.put(this.getVersion().getCode());
        buffer.put((byte)0);
        buffer.put(this.getSequenceNumber());
        byte messageClassByte = this.getMessageClass().getCode();
        messageClassByte = AbstractWireable.setBits(messageClassByte, 7, 1, this.getMessageRole().getCode());
        buffer.put(messageClassByte);
    }

    @Override
    public int getWireLength(IpmiPacketContext context) {
        return 4 + this.getData().getWireLength(context);
    }

    @Override
    public void toWire(IpmiPacketContext context, ByteBuffer buffer) {
        this.toWireHeader(buffer);
        this.getData().toWire(context, buffer);
    }

    @Override
    public void fromWire(IpmiPacketContext context, ByteBuffer buffer) {
        AbstractWireable.ignoreBytes(buffer, 3);
        this.messageClass = IpmiCode.fromBufferWithMask(RmcpMessageClass.class, buffer, 15);
        int position = buffer.position();
        if (this.messageClass != RmcpMessageClass.IPMI) {
            throw new UnsupportedOperationException("Unsupported RMCP message class " + this.messageClass);
        }
        IpmiSessionAuthenticationType type = IpmiCode.fromByte(IpmiSessionAuthenticationType.class, buffer.get(position));
        if (type != IpmiSessionAuthenticationType.RMCPP) {
            throw new UnsupportedOperationException("Unsupported IPMI 1.5 version");
        }
        this.data = new Ipmi20Ipv4SessionWrapper();
        buffer.position(position);
        this.withData(this.data);
        this.data.fromWire(context, buffer);
    }
}

