/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.sd;

import java.util.List;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.collect.registry.constant.DiscoveryClientInstance;
import org.apache.hertzbeat.collector.collect.registry.discovery.DiscoveryClient;
import org.apache.hertzbeat.collector.collect.registry.discovery.DiscoveryClientManagement;
import org.apache.hertzbeat.collector.collect.registry.discovery.entity.ServiceInstance;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.RegistryProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class NacosSdCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(NacosSdCollectImpl.class);
    private final DiscoveryClientManagement discoveryClientManagement = new DiscoveryClientManagement();

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getNacos_sd() == null) {
            throw new IllegalArgumentException("Nacos service discovery monitoring, the config is null");
        }
        if (metrics.getNacos_sd().isInvalid()) {
            throw new IllegalArgumentException("Nacos service discovery monitoring, the config is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        RegistryProtocol registryProtocol = RegistryProtocol.builder().host(metrics.getNacos_sd().getHost()).port(metrics.getNacos_sd().getPort()).discoveryClientTypeName(DiscoveryClientInstance.NACOS.name()).build();
        DiscoveryClient discoveryClient = null;
        try {
            discoveryClient = this.discoveryClientManagement.getClient(registryProtocol);
            if (discoveryClient == null) {
                builder.setCode(CollectRep.Code.FAIL);
                builder.setMsg("Failed to get Nacos discovery client");
                return;
            }
            List<ServiceInstance> services = discoveryClient.getServices();
            if (CollectionUtils.isEmpty(services)) {
                return;
            }
            services.forEach(service -> {
                CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                valueRowBuilder.addColumn(service.getAddress());
                valueRowBuilder.addColumn(String.valueOf(service.getPort()));
                valueRowBuilder.addColumn(service.getServiceName());
                valueRowBuilder.addColumn(service.getHealthStatus());
                builder.addValueRow(valueRowBuilder.build());
            });
        }
        catch (Exception e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.warn("Failed to fetch services from Nacos: {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        finally {
            if (discoveryClient != null) {
                try {
                    discoveryClient.close();
                }
                catch (Exception e) {
                    log.warn("Failed to close Nacos discovery client: {}", (Object)CommonUtil.getMessageFromThrowable((Throwable)e));
                }
            }
        }
    }

    public String supportProtocol() {
        return "nacos_sd";
    }
}

