/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.stereotype.Component;

@Converter
@Component
public class JsonLongListAttributeConverter
implements AttributeConverter<List<Long>, String> {
    public String convertToDatabaseColumn(List<Long> attribute) {
        return JsonUtil.toJson(attribute);
    }

    public List<Long> convertToEntityAttribute(String dbData) {
        if (StringUtils.isBlank((CharSequence)dbData)) {
            return List.of();
        }
        if (!JsonUtil.isJsonStr(dbData) && StringUtils.isNumeric((CharSequence)dbData)) {
            return List.of(Long.valueOf(Long.parseLong(dbData)));
        }
        TypeReference<List<Long>> typeReference = new TypeReference<List<Long>>(){};
        List<Long> longList = JsonUtil.fromJson(dbData, typeReference);
        if (longList == null && !dbData.isEmpty()) {
            if (StringUtils.isNumeric((CharSequence)dbData)) {
                return List.of(Long.valueOf(Long.parseLong(dbData)));
            }
            throw new NumberFormatException("String convert to Long error");
        }
        return longList;
    }
}

