/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.apache.hertzbeat.common.support.valid.HostValid;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_monitor", indexes={@Index(name="monitor_query_index", columnList="app"), @Index(name="monitor_query_index", columnList="host"), @Index(name="monitor_query_index", columnList="name")})
@Schema(description="Monitor Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class Monitor {
    @Id
    @Schema(title="Monitor task ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Collect task ID", example="43243543543", accessMode=Schema.AccessMode.READ_ONLY)
    private Long jobId;
    @Schema(title="task name", example="Api-TanCloud.cn", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    private @Size(max=100) String name;
    @Schema(title="Type of monitoring", example="TanCloud", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    private @Size(max=100) String app;
    @Schema(title="Scrape type: static | http_sd | dns_sd | zookeeper_sd", example="static", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    private @Size(max=100) String scrape;
    @Schema(title="peer host: ipv4, ipv6, domain name", example="192.167.25.11", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @HostValid
    private @Size(max=100) String host;
    @Schema(title="Monitoring of the acquisition interval time in seconds", example="600", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=10L)
    private @Min(value=10L) Integer intervals;
    @Schema(title="Task status 0: Paused, 1: Up, 2: Down", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    @Max(value=4L)
    private @Min(value=0L) @Max(value=4L) byte status;
    @Schema(title="Task type 0: Normal, 1: push auto create, 2: discovery auto create")
    private byte type;
    @Schema(title="task label", example="{env:test}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=4096)
    private Map<String, String> labels;
    @Schema(title="task annotations", example="{summary:this task looks good}", accessMode=Schema.AccessMode.READ_WRITE)
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=4096)
    private Map<String, String> annotations;
    @Schema(title="Monitor note description", example="Availability monitoring of the SAAS website TanCloud", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=255)
    private @Size(max=255) String description;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="2024-07-02T20:09:34.903217", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="2024-07-02T20:09:34.903217", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public Monitor clone() {
        return (Monitor)JsonUtil.fromJson(JsonUtil.toJson(this), this.getClass());
    }

    public static MonitorBuilder builder() {
        return new MonitorBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getName() {
        return this.name;
    }

    public String getApp() {
        return this.app;
    }

    public String getScrape() {
        return this.scrape;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getIntervals() {
        return this.intervals;
    }

    public byte getStatus() {
        return this.status;
    }

    public byte getType() {
        return this.type;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setScrape(String scrape) {
        this.scrape = scrape;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setIntervals(Integer intervals) {
        this.intervals = intervals;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Monitor)) {
            return false;
        }
        Monitor other = (Monitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$jobId = this.getJobId();
        Long other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        Integer this$intervals = this.getIntervals();
        Integer other$intervals = other.getIntervals();
        if (this$intervals == null ? other$intervals != null : !((Object)this$intervals).equals(other$intervals)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$scrape = this.getScrape();
        String other$scrape = other.getScrape();
        if (this$scrape == null ? other$scrape != null : !this$scrape.equals(other$scrape)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Monitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        result = result * 59 + this.getType();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        Integer $intervals = this.getIntervals();
        result = result * 59 + ($intervals == null ? 43 : ((Object)$intervals).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $scrape = this.getScrape();
        result = result * 59 + ($scrape == null ? 43 : $scrape.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "Monitor(id=" + this.getId() + ", jobId=" + this.getJobId() + ", name=" + this.getName() + ", app=" + this.getApp() + ", scrape=" + this.getScrape() + ", host=" + this.getHost() + ", intervals=" + this.getIntervals() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", labels=" + this.getLabels() + ", annotations=" + this.getAnnotations() + ", description=" + this.getDescription() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public Monitor(Long id, Long jobId, String name, String app, String scrape, String host, Integer intervals, byte status, byte type, Map<String, String> labels, Map<String, String> annotations, String description, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.jobId = jobId;
        this.name = name;
        this.app = app;
        this.scrape = scrape;
        this.host = host;
        this.intervals = intervals;
        this.status = status;
        this.type = type;
        this.labels = labels;
        this.annotations = annotations;
        this.description = description;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public Monitor() {
    }

    public static class MonitorBuilder {
        private Long id;
        private Long jobId;
        private String name;
        private String app;
        private String scrape;
        private String host;
        private Integer intervals;
        private byte status;
        private byte type;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private String description;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        MonitorBuilder() {
        }

        public MonitorBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public MonitorBuilder jobId(Long jobId) {
            this.jobId = jobId;
            return this;
        }

        public MonitorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MonitorBuilder app(String app) {
            this.app = app;
            return this;
        }

        public MonitorBuilder scrape(String scrape) {
            this.scrape = scrape;
            return this;
        }

        public MonitorBuilder host(String host) {
            this.host = host;
            return this;
        }

        public MonitorBuilder intervals(Integer intervals) {
            this.intervals = intervals;
            return this;
        }

        public MonitorBuilder status(byte status) {
            this.status = status;
            return this;
        }

        public MonitorBuilder type(byte type) {
            this.type = type;
            return this;
        }

        public MonitorBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public MonitorBuilder annotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public MonitorBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MonitorBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public MonitorBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public MonitorBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public MonitorBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public Monitor build() {
            return new Monitor(this.id, this.jobId, this.name, this.app, this.scrape, this.host, this.intervals, this.status, this.type, this.labels, this.annotations, this.description, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "Monitor.MonitorBuilder(id=" + this.id + ", jobId=" + this.jobId + ", name=" + this.name + ", app=" + this.app + ", scrape=" + this.scrape + ", host=" + this.host + ", intervals=" + this.intervals + ", status=" + this.status + ", type=" + this.type + ", labels=" + this.labels + ", annotations=" + this.annotations + ", description=" + this.description + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

