/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.apache.hertzbeat.common.entity.manager.PluginItem;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_plugin_metadata")
@Schema(description="Plugin Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class PluginMetadata {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Plugin Primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="plugin name", example="notification plugin", accessMode=Schema.AccessMode.READ_WRITE)
    @NotNull
    private String name;
    @Schema(title="Plugin activation status", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private Boolean enableStatus;
    @Schema(title="Jar file path", example="true", accessMode=Schema.AccessMode.READ_WRITE)
    private String jarFilePath;
    @Schema(title="The creator of this record", example="tom", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedBy
    private String creator;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @OneToMany(targetEntity=PluginItem.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="metadata_id", referencedColumnName="id")
    private List<PluginItem> items;
    @Schema(title="Param count", example="1", accessMode=Schema.AccessMode.READ_WRITE)
    private Integer paramCount;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginMetadata that = (PluginMetadata)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.enableStatus, that.enableStatus) && Objects.equals(this.jarFilePath, that.jarFilePath) && Objects.equals(this.creator, that.creator) && Objects.equals(this.gmtCreate, that.gmtCreate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.enableStatus, this.jarFilePath, this.creator, this.gmtCreate);
    }

    public static PluginMetadataBuilder builder() {
        return new PluginMetadataBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getEnableStatus() {
        return this.enableStatus;
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public String getCreator() {
        return this.creator;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public List<PluginItem> getItems() {
        return this.items;
    }

    public Integer getParamCount() {
        return this.paramCount;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnableStatus(Boolean enableStatus) {
        this.enableStatus = enableStatus;
    }

    public void setJarFilePath(String jarFilePath) {
        this.jarFilePath = jarFilePath;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setItems(List<PluginItem> items) {
        this.items = items;
    }

    public void setParamCount(Integer paramCount) {
        this.paramCount = paramCount;
    }

    public String toString() {
        return "PluginMetadata(id=" + this.getId() + ", name=" + this.getName() + ", enableStatus=" + this.getEnableStatus() + ", jarFilePath=" + this.getJarFilePath() + ", creator=" + this.getCreator() + ", gmtCreate=" + this.getGmtCreate() + ", items=" + this.getItems() + ", paramCount=" + this.getParamCount() + ")";
    }

    public PluginMetadata(Long id, String name, Boolean enableStatus, String jarFilePath, String creator, LocalDateTime gmtCreate, List<PluginItem> items, Integer paramCount) {
        this.id = id;
        this.name = name;
        this.enableStatus = enableStatus;
        this.jarFilePath = jarFilePath;
        this.creator = creator;
        this.gmtCreate = gmtCreate;
        this.items = items;
        this.paramCount = paramCount;
    }

    public PluginMetadata() {
    }

    public static class PluginMetadataBuilder {
        private Long id;
        private String name;
        private Boolean enableStatus;
        private String jarFilePath;
        private String creator;
        private LocalDateTime gmtCreate;
        private List<PluginItem> items;
        private Integer paramCount;

        PluginMetadataBuilder() {
        }

        public PluginMetadataBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public PluginMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PluginMetadataBuilder enableStatus(Boolean enableStatus) {
            this.enableStatus = enableStatus;
            return this;
        }

        public PluginMetadataBuilder jarFilePath(String jarFilePath) {
            this.jarFilePath = jarFilePath;
            return this;
        }

        public PluginMetadataBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public PluginMetadataBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public PluginMetadataBuilder items(List<PluginItem> items) {
            this.items = items;
            return this;
        }

        public PluginMetadataBuilder paramCount(Integer paramCount) {
            this.paramCount = paramCount;
            return this;
        }

        public PluginMetadata build() {
            return new PluginMetadata(this.id, this.name, this.enableStatus, this.jarFilePath, this.creator, this.gmtCreate, this.items, this.paramCount);
        }

        public String toString() {
            return "PluginMetadata.PluginMetadataBuilder(id=" + this.id + ", name=" + this.name + ", enableStatus=" + this.enableStatus + ", jarFilePath=" + this.jarFilePath + ", creator=" + this.creator + ", gmtCreate=" + this.gmtCreate + ", items=" + this.items + ", paramCount=" + this.paramCount + ")";
        }
    }
}

