/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataTxAttenuation
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 8847948493831117966L;
    private static final int LENGTH = 2;
    private final short txAttenuation;

    public static RadiotapDataTxAttenuation newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataTxAttenuation(rawData, offset, length);
    }

    private RadiotapDataTxAttenuation(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapTxAttenuation (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.txAttenuation = ByteArrays.getShort(rawData, offset, ByteOrder.LITTLE_ENDIAN);
    }

    private RadiotapDataTxAttenuation(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is null.");
        }
        this.txAttenuation = builder.txAttenuation;
    }

    public short getTxAttenuation() {
        return this.txAttenuation;
    }

    public int getTxAttenuationAsInt() {
        return this.txAttenuation & 0xFFFF;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.txAttenuation, ByteOrder.LITTLE_ENDIAN);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("TX attenuation: ").append(ls).append(indent).append("  TX attenuation: ").append(this.getTxAttenuationAsInt()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.txAttenuation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataTxAttenuation other = (RadiotapDataTxAttenuation)obj;
        return this.txAttenuation == other.txAttenuation;
    }

    public static final class Builder {
        private short txAttenuation;

        public Builder() {
        }

        private Builder(RadiotapDataTxAttenuation obj) {
            this.txAttenuation = obj.txAttenuation;
        }

        public Builder txAttenuation(short txAttenuation) {
            this.txAttenuation = txAttenuation;
            return this;
        }

        public RadiotapDataTxAttenuation build() {
            return new RadiotapDataTxAttenuation(this);
        }
    }
}

