/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.pcap4j.util.ByteArrays;

public final class IpV6OptionType
extends NamedNumber<Byte, IpV6OptionType> {
    private static final long serialVersionUID = 2460312908857953021L;
    public static final IpV6OptionType PAD1 = new IpV6OptionType((byte)0, "Pad1");
    public static final IpV6OptionType PADN = new IpV6OptionType((byte)1, "PadN");
    public static final IpV6OptionType JUMBO_PAYLOAD = new IpV6OptionType((byte)-62, "Jumbo Payload");
    public static final IpV6OptionType RPL = new IpV6OptionType((byte)99, "RPL");
    public static final IpV6OptionType TUNNEL_ENCAPSULATION_LIMIT = new IpV6OptionType((byte)4, "Tunnel Encapsulation Limit");
    public static final IpV6OptionType ROUTER_ALERT = new IpV6OptionType((byte)5, "Router Alert");
    public static final IpV6OptionType QUICK_START = new IpV6OptionType((byte)38, "Quick-Start");
    public static final IpV6OptionType CALIPSO = new IpV6OptionType((byte)7, "CALIPSO");
    public static final IpV6OptionType SMF_DPD = new IpV6OptionType((byte)8, "SMF_DPD");
    public static final IpV6OptionType HOME_ADDRESS = new IpV6OptionType((byte)-55, "Home Address");
    public static final IpV6OptionType ENDPOINT_IDENTIFICATION = new IpV6OptionType((byte)-118, "Endpoint Identification");
    public static final IpV6OptionType ILNP_NONCE = new IpV6OptionType((byte)-117, "ILNP Nonce");
    public static final IpV6OptionType LINE_IDENTIFICATION = new IpV6OptionType((byte)-116, "Line-Identification");
    public static final IpV6OptionType MPL = new IpV6OptionType((byte)109, "MPL");
    public static final IpV6OptionType IP_DFF = new IpV6OptionType((byte)-18, "IP_DFF");
    private static final Map<Byte, IpV6OptionType> registry = new HashMap<Byte, IpV6OptionType>();
    private final IpV6OptionTypeAction action;

    public IpV6OptionType(Byte value, String name) {
        super(value, name);
        switch (value & 0xC0) {
            case 0: {
                this.action = IpV6OptionTypeAction.SKIP;
                break;
            }
            case 64: {
                this.action = IpV6OptionTypeAction.DISCARD;
                break;
            }
            case 128: {
                this.action = IpV6OptionTypeAction.DISCARD_AND_SEND_ICMP;
                break;
            }
            case 192: {
                this.action = IpV6OptionTypeAction.DISCARD_AND_SEND_ICMP_IF_NOT_MULTICAST;
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here");
            }
        }
    }

    public static IpV6OptionType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV6OptionType(value, "unknown");
    }

    public static IpV6OptionType register(IpV6OptionType type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return "0x" + ByteArrays.toHexString((Byte)this.value(), "");
    }

    @Override
    public int compareTo(IpV6OptionType o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    public IpV6OptionTypeAction getAction() {
        return this.action;
    }

    public boolean optionDataMayChange() {
        return ((Byte)this.value() & 0x20) != 0;
    }

    static {
        registry.put((Byte)PAD1.value(), PAD1);
        registry.put((Byte)PADN.value(), PADN);
        registry.put((Byte)JUMBO_PAYLOAD.value(), JUMBO_PAYLOAD);
        registry.put((Byte)RPL.value(), RPL);
        registry.put((Byte)TUNNEL_ENCAPSULATION_LIMIT.value(), TUNNEL_ENCAPSULATION_LIMIT);
        registry.put((Byte)ROUTER_ALERT.value(), ROUTER_ALERT);
        registry.put((Byte)QUICK_START.value(), QUICK_START);
        registry.put((Byte)CALIPSO.value(), CALIPSO);
        registry.put((Byte)SMF_DPD.value(), SMF_DPD);
        registry.put((Byte)HOME_ADDRESS.value(), HOME_ADDRESS);
        registry.put((Byte)ENDPOINT_IDENTIFICATION.value(), ENDPOINT_IDENTIFICATION);
        registry.put((Byte)ILNP_NONCE.value(), ILNP_NONCE);
        registry.put((Byte)LINE_IDENTIFICATION.value(), LINE_IDENTIFICATION);
        registry.put((Byte)MPL.value(), MPL);
        registry.put((Byte)IP_DFF.value(), IP_DFF);
    }

    public static enum IpV6OptionTypeAction {
        SKIP(0),
        DISCARD(1),
        DISCARD_AND_SEND_ICMP(2),
        DISCARD_AND_SEND_ICMP_IF_NOT_MULTICAST(3);

        private final byte value;

        private IpV6OptionTypeAction(byte value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

