/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;

final class FakeConnection
implements ModalCloseable {
    private final long closeSleepMs;
    private final AtomicInteger closes = new AtomicInteger(0);
    private final CountDownLatch closedLatch = new CountDownLatch(1);

    FakeConnection() {
        this(0L);
    }

    FakeConnection(long closeSleepMs) {
        this.closeSleepMs = closeSleepMs;
    }

    public void close(CloseMode closeMode) {
        if (this.closeSleepMs > 0L) {
            try {
                Thread.sleep(this.closeSleepMs);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        this.closes.incrementAndGet();
        this.closedLatch.countDown();
    }

    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    int closeCount() {
        return this.closes.get();
    }

    boolean awaitClosed(long ms) throws InterruptedException {
        return this.closedLatch.await(ms, TimeUnit.MILLISECONDS);
    }
}

