/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.ParseException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestTimeout {
    TestTimeout() {
    }

    private void checkToDays(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toDays(value), (long)Timeout.of((long)value, (TimeUnit)timeUnit).toDays());
    }

    private void checkToHours(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toHours(value), (long)Timeout.of((long)value, (TimeUnit)timeUnit).toHours());
    }

    private void checkToMicroseconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toMicros(value), (long)Timeout.of((long)value, (TimeUnit)timeUnit).toMicroseconds());
    }

    private void checkToMilliseconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toMillis(value), (long)Timeout.of((long)value, (TimeUnit)timeUnit).toMilliseconds());
    }

    private void checkToMinutes(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toMinutes(value), (long)Timeout.of((long)value, (TimeUnit)timeUnit).toMinutes());
    }

    private void checkToNanoseconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toNanos(value), (long)Timeout.of((long)value, (TimeUnit)timeUnit).toNanoseconds());
    }

    private void checkToSeconds(long value, TimeUnit timeUnit) {
        Assertions.assertEquals((long)timeUnit.toSeconds(value), (long)Timeout.of((long)value, (TimeUnit)timeUnit).toSeconds());
    }

    private void test(long value) {
        for (TimeUnit timeUnit : TimeUnit.values()) {
            this.checkToDays(value, timeUnit);
            this.checkToHours(value, timeUnit);
            this.checkToMinutes(value, timeUnit);
            this.checkToSeconds(value, timeUnit);
            this.checkToMilliseconds(value, timeUnit);
            this.checkToMicroseconds(value, timeUnit);
            this.checkToNanoseconds(value, timeUnit);
        }
    }

    @Test
    void test0() {
        this.test(0L);
    }

    @Test
    void test1() {
        this.test(1L);
    }

    @Test
    void testDisabled() {
        Assertions.assertTrue((boolean)Timeout.DISABLED.isDisabled());
        Assertions.assertFalse((boolean)Timeout.DISABLED.isEnabled());
    }

    private void testFactory(TimeUnit timeUnit) {
        Assertions.assertEquals((Object)((Object)timeUnit), (Object)((Object)Timeout.of((long)1L, (TimeUnit)timeUnit).getTimeUnit()));
    }

    @Test
    void testFactoryForDays() {
        this.testFactory(TimeUnit.DAYS);
    }

    @Test
    void testFactoryForDuration() {
        this.assertConvertion(Duration.ZERO);
        this.assertConvertion(Duration.ofDays(1L));
        this.assertConvertion(Duration.ofHours(1L));
        this.assertConvertion(Duration.ofMillis(1L));
        this.assertConvertion(Duration.ofNanos(1L));
        this.assertConvertion(Duration.ofSeconds(1L));
        this.assertConvertion(Duration.ofSeconds(1L, 1L));
    }

    private void assertConvertion(Duration duration) {
        Assertions.assertEquals((Object)duration, (Object)Timeout.of((Duration)duration).toDuration());
    }

    @Test
    void testFactoryForHours() {
        this.testFactory(TimeUnit.HOURS);
    }

    @Test
    void testFactoryForMicroseconds() {
        this.testFactory(TimeUnit.MICROSECONDS);
    }

    @Test
    void testFactoryForMillisseconds() {
        this.testFactory(TimeUnit.MILLISECONDS);
    }

    @Test
    void testFactoryForMinutes() {
        this.testFactory(TimeUnit.MINUTES);
    }

    @Test
    void testFactoryForNanoseconds() {
        this.testFactory(TimeUnit.NANOSECONDS);
    }

    @Test
    void testFactoryForSeconds() {
        this.testFactory(TimeUnit.SECONDS);
    }

    @Test
    void testMaxInt() {
        this.test(Integer.MAX_VALUE);
    }

    @Test
    void testMaxLong() {
        this.test(Long.MAX_VALUE);
    }

    @Test
    void testNegative1() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.test(-1L));
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"9223372036854775807 SECONDS", (Object)Timeout.ofSeconds((long)Long.MAX_VALUE).toString());
        Assertions.assertEquals((Object)"0 MILLISECONDS", (Object)Timeout.ZERO_MILLISECONDS.toString());
    }

    @Test
    void testFromString() throws ParseException {
        Assertions.assertEquals((Object)Timeout.ofSeconds((long)Long.MAX_VALUE), (Object)Timeout.parse((String)"9223372036854775807 SECONDS"));
        Assertions.assertEquals((Object)Timeout.ofSeconds((long)Long.MAX_VALUE), (Object)Timeout.parse((String)"9223372036854775807 Seconds"));
        Assertions.assertEquals((Object)Timeout.ofSeconds((long)Long.MAX_VALUE), (Object)Timeout.parse((String)"9223372036854775807  Seconds"));
        Assertions.assertEquals((Object)Timeout.ofSeconds((long)Long.MAX_VALUE), (Object)Timeout.parse((String)"9223372036854775807\tSeconds"));
        Assertions.assertEquals((Object)Timeout.ZERO_MILLISECONDS, (Object)Timeout.parse((String)"0 MILLISECONDS"));
    }
}

