/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.flow.question;

import org.apache.ignite.internal.cli.core.flow.FlowInterruptException;
import org.apache.ignite.internal.cli.core.flow.question.QuestionWriterReader;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.MaskingCallback;
import org.jline.reader.UserInterruptException;
import org.jline.widget.TailTipWidgets;

public class JlineQuestionWriterReader
implements QuestionWriterReader {
    private final LineReader reader;
    private final TailTipWidgets widgets;

    public JlineQuestionWriterReader(LineReader reader, TailTipWidgets widgets) {
        this.reader = reader;
        this.widgets = widgets;
    }

    public JlineQuestionWriterReader(LineReader reader) {
        this(reader, null);
    }

    @Override
    public String readAnswer(String question) {
        if (this.widgets != null) {
            this.widgets.disable();
        }
        this.reader.setVariable("disable-history", (Object)true);
        String s = this.readLine(this.reader, question);
        this.reader.setVariable("disable-history", (Object)false);
        if (this.widgets != null) {
            this.widgets.enable();
        }
        return s;
    }

    private String readLine(LineReader reader, String question) {
        try {
            return reader.readLine(question, null, (MaskingCallback)null, null);
        }
        catch (EndOfFileException | UserInterruptException ignored) {
            throw new FlowInterruptException();
        }
    }
}

