/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.util.GridUnsafe;

public class PageHeader {
    public static final long PAGE_MARKER = 1L;
    private static final long DIRTY_FLAG = 0x100000000000000L;
    private static final int RELATIVE_PTR_OFFSET = 8;
    private static final int PAGE_ID_OFFSET = 16;
    private static final int PAGE_GROUP_ID_OFFSET = 24;
    private static final int PAGE_PIN_CNT_OFFSET = 28;
    private static final int PAGE_TMP_BUF_OFFSET = 40;

    public static void initNew(long absPtr, long relative) {
        PageHeader.relative(absPtr, relative);
        PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
        GridUnsafe.putLong((long)absPtr, (long)1L);
        GridUnsafe.putInt((long)(absPtr + 28L), (int)0);
    }

    public static boolean dirty(long absPtr) {
        return PageHeader.flag(absPtr, 0x100000000000000L);
    }

    public static boolean dirty(long absPtr, boolean dirty) {
        return PageHeader.flag(absPtr, 0x100000000000000L, dirty);
    }

    private static boolean flag(long absPtr, long flag) {
        assert ((flag & 0xFFFFFFFFFFFFFFL) == 0L);
        assert (Long.bitCount(flag) == 1);
        long relPtrWithFlags = GridUnsafe.getLong((long)(absPtr + 8L));
        return (relPtrWithFlags & flag) != 0L;
    }

    private static boolean flag(long absPtr, long flag, boolean set) {
        boolean was;
        assert ((flag & 0xFFFFFFFFFFFFFFL) == 0L);
        assert (Long.bitCount(flag) == 1);
        long relPtrWithFlags = GridUnsafe.getLong((long)(absPtr + 8L));
        boolean bl = was = (relPtrWithFlags & flag) != 0L;
        relPtrWithFlags = set ? (relPtrWithFlags |= flag) : (relPtrWithFlags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        GridUnsafe.putLong((long)(absPtr + 8L), (long)relPtrWithFlags);
        return was;
    }

    public static boolean isAcquired(long absPtr) {
        return GridUnsafe.getInt((long)(absPtr + 28L)) > 0;
    }

    public static int acquirePage(long absPtr) {
        return GridUnsafe.incrementAndGetInt((long)(absPtr + 28L));
    }

    public static int releasePage(long absPtr) {
        return GridUnsafe.decrementAndGetInt((long)(absPtr + 28L));
    }

    public static int pinCount(long absPtr) {
        return GridUnsafe.getIntVolatile(null, (long)absPtr);
    }

    public static long readRelative(long absPtr) {
        return GridUnsafe.getLong((long)(absPtr + 8L)) & 0xFFFFFFFFFFFFFFL;
    }

    public static void relative(long absPtr, long relPtr) {
        GridUnsafe.putLong((long)(absPtr + 8L), (long)(relPtr & 0xFFFFFFFFFFFFFFL));
    }

    public static void writeTimestamp(long absPtr, long tstamp) {
        GridUnsafe.putLongVolatile(null, (long)absPtr, (long)((tstamp &= 0xFFFFFFFFFFFFFF00L) | 1L));
    }

    public static long readTimestamp(long absPtr) {
        long markerAndTs = GridUnsafe.getLong((long)absPtr);
        return markerAndTs & 0xFFFFFFFFFFFFFF00L;
    }

    public static void tempBufferPointer(long absPtr, long tmpRelPtr) {
        GridUnsafe.putLong((long)(absPtr + 40L), (long)tmpRelPtr);
    }

    public static long tempBufferPointer(long absPtr) {
        return GridUnsafe.getLong((long)(absPtr + 40L));
    }

    public static long readPageId(long absPtr) {
        return GridUnsafe.getLong((long)(absPtr + 16L));
    }

    private static void pageId(long absPtr, long pageId) {
        GridUnsafe.putLong((long)(absPtr + 16L), (long)pageId);
    }

    private static int readPageGroupId(long absPtr) {
        return GridUnsafe.getInt((long)(absPtr + 24L));
    }

    private static void pageGroupId(long absPtr, int grpId) {
        GridUnsafe.putInt((long)(absPtr + 24L), (int)grpId);
    }

    public static FullPageId fullPageId(long absPtr) {
        return new FullPageId(PageHeader.readPageId(absPtr), PageHeader.readPageGroupId(absPtr));
    }

    public static void fullPageId(long absPtr, FullPageId fullPageId) {
        PageHeader.pageId(absPtr, fullPageId.pageId());
        PageHeader.pageGroupId(absPtr, fullPageId.groupId());
    }
}

