/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.configuration.schema.VolatilePageMemoryProfileConfiguration;
import org.apache.ignite.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite.internal.pagememory.inmemory.VolatilePageMemory;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.pagememory.util.PageLockListenerNoOp;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.util.IgniteUtils;

public class VolatilePageMemoryDataRegion
implements DataRegion<VolatilePageMemory> {
    private static final int FREE_LIST_GROUP_ID = 0;
    private static final int FREE_LIST_PARTITION_ID = 0;
    private final VolatilePageMemoryProfileConfiguration cfg;
    private final PageIoRegistry ioRegistry;
    private final int pageSize;
    private volatile VolatilePageMemory pageMemory;
    private volatile FreeListImpl freeList;

    VolatilePageMemoryDataRegion(VolatilePageMemoryProfileConfiguration cfg, PageIoRegistry ioRegistry, int pageSize) {
        this.cfg = cfg;
        this.ioRegistry = ioRegistry;
        this.pageSize = pageSize;
    }

    public void start() {
        VolatilePageMemory pageMemory = new VolatilePageMemory(this.cfg, this.ioRegistry, this.pageSize);
        pageMemory.start();
        try {
            this.freeList = VolatilePageMemoryDataRegion.createFreeList((PageMemory)pageMemory);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating free list", (Throwable)e);
        }
        this.pageMemory = pageMemory;
    }

    private static FreeListImpl createFreeList(PageMemory pageMemory) throws IgniteInternalCheckedException {
        long metaPageId = pageMemory.allocatePageNoReuse(0, 0, (byte)2);
        return new FreeListImpl("VolatileFreeList", 0, 0, pageMemory, (PageLockListener)PageLockListenerNoOp.INSTANCE, metaPageId, true, null, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
    }

    public void stop() throws Exception {
        IgniteUtils.closeAllManually((ManuallyCloseable[])new ManuallyCloseable[]{this.freeList, this.pageMemory != null ? () -> this.pageMemory.stop(true) : null});
    }

    public VolatilePageMemory pageMemory() {
        this.checkDataRegionStarted();
        return this.pageMemory;
    }

    public ReuseList reuseList() {
        return this.freeList;
    }

    public FreeListImpl freeList() {
        this.checkDataRegionStarted();
        return this.freeList;
    }

    private void checkDataRegionStarted() {
        if (this.pageMemory == null) {
            throw new StorageException("Data region not started");
        }
    }
}

