/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format;

import java.util.Set;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.FormatPattern;
import org.apache.calcite.util.format.postgresql.format.compiled.AmPmCompiledPattern;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class AmPmFormatPattern
extends FormatPattern {
    private final boolean upperCase;
    private final boolean includePeriods;

    public AmPmFormatPattern(String pattern) {
        super(pattern);
        switch (pattern) {
            case "am": 
            case "pm": {
                this.upperCase = false;
                this.includePeriods = false;
                break;
            }
            case "AM": 
            case "PM": {
                this.upperCase = true;
                this.includePeriods = false;
                break;
            }
            case "a.m.": 
            case "p.m.": {
                this.upperCase = false;
                this.includePeriods = true;
                break;
            }
            default: {
                this.upperCase = true;
                this.includePeriods = true;
            }
        }
    }

    @Override
    protected CompiledPattern buildCompiledPattern(Set<PatternModifier> modifiers) {
        return new AmPmCompiledPattern(modifiers, this.upperCase, this.includePeriods);
    }
}

