/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite.internal.sql.engine.prepare.PlanId;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.util.Cloner;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class MultiStepPlan
implements ExplainablePlan {
    private final PlanId id;
    private final SqlQueryType type;
    private final ResultSetMetadata meta;
    private final IgniteRel root;
    private final ParameterMetadata parameterMetadata;
    private final int catalogVersion;
    @Nullable
    private final QueryPlan fastPlan;

    public MultiStepPlan(PlanId id, SqlQueryType type, IgniteRel root, ResultSetMetadata meta, ParameterMetadata parameterMetadata, int catalogVersion, @Nullable QueryPlan fastPlan) {
        this.id = id;
        this.type = type;
        this.root = root;
        this.meta = meta;
        this.parameterMetadata = parameterMetadata;
        this.catalogVersion = catalogVersion;
        this.fastPlan = fastPlan;
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public SqlQueryType type() {
        return this.type;
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.root, Commons.cluster());
        return RelOptUtil.toString((RelNode)clonedRoot, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    public IgniteRel root() {
        return this.root;
    }

    @Nullable
    public QueryPlan fastPlan() {
        return this.fastPlan;
    }
}

