/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class CatalogStorageProfilesDescriptor {
    public static final CatalogObjectSerializer<CatalogStorageProfilesDescriptor> SERIALIZER = new StorageProfilesDescriptorSerializer();
    private final List<CatalogStorageProfileDescriptor> storageProfiles;
    private final CatalogStorageProfileDescriptor defaultStorageProfile;

    public CatalogStorageProfilesDescriptor(List<CatalogStorageProfileDescriptor> storageProfiles) {
        this.storageProfiles = storageProfiles;
        this.defaultStorageProfile = storageProfiles.isEmpty() ? null : storageProfiles.get(0);
    }

    public List<CatalogStorageProfileDescriptor> profiles() {
        return this.storageProfiles;
    }

    public CatalogStorageProfileDescriptor defaultProfile() {
        return this.defaultStorageProfile;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class StorageProfilesDescriptorSerializer
    implements CatalogObjectSerializer<CatalogStorageProfilesDescriptor> {
        private StorageProfilesDescriptorSerializer() {
        }

        @Override
        public CatalogStorageProfilesDescriptor readFrom(IgniteDataInput input) throws IOException {
            List<CatalogStorageProfileDescriptor> storageProfileDescriptors = CatalogSerializationUtils.readList(CatalogStorageProfileDescriptor.SERIALIZER, input);
            return new CatalogStorageProfilesDescriptor(storageProfileDescriptors);
        }

        @Override
        public void writeTo(CatalogStorageProfilesDescriptor descriptor, IgniteDataOutput output) throws IOException {
            CatalogSerializationUtils.writeList(descriptor.storageProfiles, CatalogStorageProfileDescriptor.SERIALIZER, output);
        }
    }
}

